/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.playbosswar.com.commandtimer.sentry.EventProcessor;
import me.playbosswar.com.commandtimer.sentry.Hint;
import me.playbosswar.com.commandtimer.sentry.SentryEvent;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.UncaughtExceptionHandlerIntegration;
import me.playbosswar.com.commandtimer.sentry.hints.EventDropReason;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryException;
import me.playbosswar.com.commandtimer.sentry.util.HintUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeduplicateMultithreadedEventProcessor
implements EventProcessor {
    @NotNull
    private final Map<String, Long> processedEvents = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final SentryOptions options;

    public DeduplicateMultithreadedEventProcessor(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Override
    @Nullable
    public SentryEvent process(@NotNull SentryEvent event, @NotNull Hint hint) {
        if (!HintUtils.hasType(hint, UncaughtExceptionHandlerIntegration.UncaughtExceptionHint.class)) {
            return event;
        }
        SentryException exception = event.getUnhandledException();
        if (exception == null) {
            return event;
        }
        String type = exception.getType();
        if (type == null) {
            return event;
        }
        Long currentEventTid = exception.getThreadId();
        if (currentEventTid == null) {
            return event;
        }
        Long tid = this.processedEvents.get(type);
        if (tid != null && !tid.equals(currentEventTid)) {
            this.options.getLogger().log(SentryLevel.INFO, "Event %s has been dropped due to multi-threaded deduplication", event.getEventId());
            HintUtils.setEventDropReason(hint, EventDropReason.MULTITHREADED_DEDUPLICATION);
            return null;
        }
        this.processedEvents.put(type, currentEventTid);
        return event;
    }
}

