/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.conditionsengine;

import java.io.File;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.ConditionRule;
import me.playbosswar.com.api.ConditionRules;
import me.playbosswar.com.conditionsengine.MethodSignature;
import me.playbosswar.com.utils.Files;
import me.playbosswar.com.utils.Futures;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionEngineManager {
    private final List<ConditionExtension> conditionExtensions = new ArrayList<ConditionExtension>();
    @NotNull
    private final File folder = new File(CommandTimerPlugin.getPlugin().getDataFolder(), "extensions");
    @NotNull
    private static final Set<MethodSignature> ABSTRACT_EXPANSION_METHODS = Arrays.stream(ConditionExtension.class.getDeclaredMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).map(method -> new MethodSignature(method.getName(), method.getParameterTypes())).collect(Collectors.toSet());

    public ConditionEngineManager() {
        this.registerAll();
    }

    public void disable() {
        this.unregisterAll();
    }

    public List<ConditionExtension> getConditionExtensions() {
        return this.conditionExtensions;
    }

    public ConditionExtension getConditionExtension(String name) {
        Optional<ConditionExtension> optional = this.conditionExtensions.stream().filter(conditionExtension -> conditionExtension.getConditionGroupName().equals(name)).findFirst();
        return optional.orElse(null);
    }

    public ConditionRule getRule(String conditionGroup, String ruleName) {
        Optional<ConditionExtension> optionalConditionExtension = this.conditionExtensions.stream().filter(conditionExtension -> conditionExtension.getConditionGroupName().equals(conditionGroup)).findFirst();
        if (optionalConditionExtension.isPresent()) {
            ConditionRules rules = optionalConditionExtension.get().getRules();
            for (ConditionRule rule : rules) {
                if (!rule.getName().equals(ruleName)) continue;
                return rule;
            }
        }
        return null;
    }

    public void onDisable() {
        this.conditionExtensions.forEach(conditionExtension -> conditionExtension.getRules().clear());
    }

    public void register(@NotNull Class<? extends ConditionExtension> clazz) {
        try {
            ConditionExtension condition = this.createExpansionInstance(clazz);
            Objects.requireNonNull(condition.getAuthor(), "The condition author is null!");
            Objects.requireNonNull(condition.getConditionGroupName(), "The condition name is null!");
            Objects.requireNonNull(condition.getVersion(), "The condition version is null!");
            condition.register();
            if (!condition.getEvents().isEmpty()) {
                condition.getEvents().forEach(event -> {
                    if (event instanceof Listener) {
                        Bukkit.getPluginManager().registerEvents((Listener)event, CommandTimerPlugin.getPlugin());
                    }
                });
            }
        }
        catch (LinkageError | NullPointerException ex) {
            String reason = ex instanceof LinkageError ? " (Is a dependency missing?)" : " - One of its properties is null which is not allowed!";
            CommandTimerPlugin.getPlugin().getLogger().severe("Failed to load expansion class " + clazz.getSimpleName() + reason);
            CommandTimerPlugin.getPlugin().getLogger().log(Level.SEVERE, "", ex);
        }
    }

    public boolean register(@NotNull ConditionExtension condition) {
        if (!condition.canRegister()) {
            return false;
        }
        this.conditionExtensions.add(condition);
        if (condition instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)condition, CommandTimerPlugin.getPlugin());
        }
        CommandTimerPlugin.getPlugin().getLogger().info("Successfully registered conditions: " + condition.getConditionGroupName() + ", " + condition.getRules().size() + " were addded");
        return true;
    }

    private void registerAll() {
        Futures.onMainThread(CommandTimerPlugin.getPlugin(), this.findExpansionsOnDisk(), (classes, exception) -> {
            if (exception != null) {
                CommandTimerPlugin.getPlugin().getLogger().log(Level.SEVERE, "failed to load class files of expansions", (Throwable)exception);
                return;
            }
            classes.stream().filter(Objects::nonNull).forEach(this::register);
        });
    }

    private void unregisterAll() {
        this.conditionExtensions.clear();
    }

    @Nullable
    public ConditionExtension createExpansionInstance(@NotNull Class<? extends ConditionExtension> clazz) throws LinkageError {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof LinkageError) {
                throw (LinkageError)ex.getCause();
            }
            return null;
        }
    }

    @NotNull
    public @NotNull CompletableFuture<@NotNull List<@Nullable Class<? extends ConditionExtension>>> findExpansionsOnDisk() {
        return Arrays.stream((Object[])Objects.requireNonNull(this.folder.listFiles((dir, name) -> name.endsWith(".jar")))).map(this::findExpansionInFile).collect(Futures.collector());
    }

    public @NotNull CompletableFuture<@Nullable Class<? extends ConditionExtension>> findExpansionInFile(@NotNull File file) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Class<ConditionExtension> expansionClass = Files.findClass(file, ConditionExtension.class);
                if (expansionClass == null) {
                    CommandTimerPlugin.getPlugin().getLogger().severe("Failed to load Condition: " + file.getName() + ", as it does not have a class which extends ConditionExtension.");
                    return null;
                }
                Set expansionMethods = Arrays.stream(expansionClass.getDeclaredMethods()).map(method -> new MethodSignature(method.getName(), method.getParameterTypes())).collect(Collectors.toSet());
                if (!expansionMethods.containsAll(ABSTRACT_EXPANSION_METHODS)) {
                    CommandTimerPlugin.getPlugin().getLogger().severe("Failed to load Condition: " + file.getName() + ", as it does not have the required methods declared for a ConditionExtension.");
                    return null;
                }
                return expansionClass;
            }
            catch (VerifyError ex) {
                CommandTimerPlugin.getPlugin().getLogger().severe("Failed to load Condition class " + file.getName() + " (Is a dependency missing?)");
                CommandTimerPlugin.getPlugin().getLogger().severe("Cause: " + ex.getClass().getSimpleName() + " " + ex.getMessage());
                return null;
            }
            catch (Exception ex) {
                throw new CompletionException(ex);
            }
        });
    }
}

