/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.events.EventConfiguration;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.commandtimer.sentry.SpanStatus;
import me.playbosswar.com.conditionsengine.validations.Condition;
import me.playbosswar.com.conditionsengine.validations.ConditionType;
import me.playbosswar.com.conditionsengine.validations.SimpleCondition;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.tasks.persistors.ConditionPersistor;
import me.playbosswar.com.tasks.persistors.DaysPersistor;
import me.playbosswar.com.tasks.persistors.EventConfigurationPersistor;
import me.playbosswar.com.tasks.persistors.TaskCommandPersistor;
import me.playbosswar.com.tasks.persistors.TaskIntervalPersistor;
import me.playbosswar.com.tasks.persistors.TaskTimePersistor;
import me.playbosswar.com.utils.Files;
import me.playbosswar.com.utils.gson.GsonConverter;

@DatabaseTable(tableName="tasks")
public class Task {
    @DatabaseField(id=true)
    private UUID id;
    @DatabaseField
    private String name = "";
    @DatabaseField(persisterClass=TaskCommandPersistor.class)
    private Collection<TaskCommand> commands = new ArrayList<TaskCommand>();
    @DatabaseField(persisterClass=TaskIntervalPersistor.class)
    private TaskInterval interval = new TaskInterval(0, 0, 0, 5);
    @DatabaseField(persisterClass=TaskTimePersistor.class)
    private Collection<TaskTime> times = new ArrayList<TaskTime>();
    @DatabaseField
    private double random = 1.0;
    @DatabaseField(persisterClass=DaysPersistor.class)
    private Collection<DayOfWeek> days = new ArrayList<DayOfWeek>();
    @DatabaseField
    private int executionLimit = -1;
    private int timesExecuted = 0;
    private int lastExecutedCommandIndex = 0;
    private Date lastExecuted = new Date();
    @DatabaseField
    private CommandExecutionMode commandExecutionMode = CommandExecutionMode.ALL;
    @DatabaseField(persisterClass=TaskIntervalPersistor.class)
    private TaskInterval commandExecutionInterval = new TaskInterval(0, 0, 0, 1);
    @DatabaseField
    private boolean active = false;
    @DatabaseField
    private boolean resetExecutionsAfterRestart = false;
    @DatabaseField(persisterClass=ConditionPersistor.class)
    private Condition condition;
    @DatabaseField(persisterClass=EventConfigurationPersistor.class)
    private Collection<EventConfiguration> events = new ArrayList<EventConfiguration>();

    Task() {
    }

    public Task(String name) {
        this.id = UUID.randomUUID();
        this.name = name;
        this.days.add(DayOfWeek.MONDAY);
        this.days.add(DayOfWeek.TUESDAY);
        this.days.add(DayOfWeek.WEDNESDAY);
        this.days.add(DayOfWeek.THURSDAY);
        this.days.add(DayOfWeek.FRIDAY);
        this.days.add(DayOfWeek.SATURDAY);
        this.days.add(DayOfWeek.SUNDAY);
        this.condition = new Condition(ConditionType.SIMPLE, new ArrayList<Condition>(), new SimpleCondition());
        this.storeInstance();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.replaceAll(" ", "");
        this.storeInstance();
    }

    public List<TaskCommand> getCommands() {
        return this.commands.stream().collect(Collectors.toList());
    }

    public void setCommands(List<TaskCommand> commands) {
        this.commands = commands;
        this.storeInstance();
    }

    public void addCommand(TaskCommand command) {
        if (command.getCommand().startsWith("/")) {
            command.setCommand(command.getCommand().substring(1));
        }
        this.commands.add(command);
        this.storeInstance();
    }

    public void removeCommand(TaskCommand command) {
        this.commands.remove(command);
        this.storeInstance();
    }

    public TaskInterval getInterval() {
        return this.interval;
    }

    public void setInterval(TaskInterval interval) {
        this.interval = interval;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public List<TaskTime> getTimes() {
        return this.times.stream().collect(Collectors.toList());
    }

    public void setTimes(List<TaskTime> times) {
        this.times = times;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public void addTime(TaskTime time) {
        this.times.add(time);
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public void removeTime(TaskTime time) {
        this.times.remove(time);
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public double getRandom() {
        return this.random;
    }

    public void setRandom(double random) {
        this.random = random;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public List<DayOfWeek> getDays() {
        return this.days.stream().collect(Collectors.toList());
    }

    public void setDays(List<DayOfWeek> days) {
        this.days = days;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public void toggleDay(DayOfWeek day) {
        if (this.days.contains(day)) {
            this.days.remove(day);
        } else {
            this.days.add(day);
        }
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public int getExecutionLimit() {
        return this.executionLimit;
    }

    public void setExecutionLimit(int executionLimit) {
        this.executionLimit = executionLimit;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public int getTimesExecuted() {
        return this.timesExecuted;
    }

    public void setTimesExecuted(int timesExecuted) {
        this.timesExecuted = timesExecuted;
    }

    public Date getLastExecuted() {
        return this.lastExecuted;
    }

    public void setLastExecuted(Date lastExecuted) {
        this.lastExecuted = lastExecuted;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.lastExecuted = new Date();
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public void toggleActive() {
        this.active = !this.active;
        this.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this);
    }

    public CommandExecutionMode getCommandExecutionMode() {
        return this.commandExecutionMode;
    }

    public void setCommandExecutionMode(CommandExecutionMode commandExecutionMode) {
        this.commandExecutionMode = commandExecutionMode;
    }

    public void switchCommandExecutionMode() {
        if (this.commandExecutionMode.equals((Object)CommandExecutionMode.ALL)) {
            this.commandExecutionMode = CommandExecutionMode.ORDERED;
            this.storeInstance();
            return;
        }
        if (this.commandExecutionMode.equals((Object)CommandExecutionMode.ORDERED)) {
            this.commandExecutionMode = CommandExecutionMode.RANDOM;
            this.storeInstance();
            return;
        }
        if (this.commandExecutionMode.equals((Object)CommandExecutionMode.RANDOM)) {
            this.commandExecutionMode = CommandExecutionMode.INTERVAL;
            this.storeInstance();
            return;
        }
        if (this.commandExecutionMode.equals((Object)CommandExecutionMode.INTERVAL)) {
            this.commandExecutionMode = CommandExecutionMode.ALL;
            this.storeInstance();
        }
    }

    public boolean isResetExecutionsAfterRestart() {
        return this.resetExecutionsAfterRestart;
    }

    public void setResetExecutionsAfterRestart(boolean resetExecutionsAfterRestart) {
        this.resetExecutionsAfterRestart = resetExecutionsAfterRestart;
        this.storeInstance();
    }

    public void toggleResetExecutionAfterRestart() {
        this.resetExecutionsAfterRestart = !this.resetExecutionsAfterRestart;
        this.storeInstance();
    }

    public int getLastExecutedCommandIndex() {
        return this.lastExecutedCommandIndex;
    }

    public void setLastExecutedCommandIndex(int lastExecutedCommandIndex) {
        this.lastExecutedCommandIndex = lastExecutedCommandIndex;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public TaskInterval getCommandExecutionInterval() {
        return this.commandExecutionInterval;
    }

    public void setCommandExecutionInterval(TaskInterval commandExecutionInterval) {
        this.commandExecutionInterval = commandExecutionInterval;
    }

    public List<EventConfiguration> getEvents() {
        return this.events.stream().collect(Collectors.toList());
    }

    public void setEvents(List<EventConfiguration> events) {
        this.events = events;
    }

    public boolean hasCondition() {
        if (this.condition == null) {
            return false;
        }
        if (!this.condition.getConditions().isEmpty()) {
            return true;
        }
        if (this.condition.getSimpleCondition() == null) {
            return false;
        }
        return ((SimpleCondition)this.getCondition().getSimpleCondition()).getConditionGroup() != null;
    }

    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeInstance() {
        if (CommandTimerPlugin.getInstance().getConfig().getBoolean("database.enabled")) {
            try {
                CommandTimerPlugin.getTaskDao().createOrUpdate(this);
                Files.updateLocalTaskMetadata(this);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return;
        }
        ITransaction transaction = Sentry.startTransaction("storeInstance()", "task");
        GsonConverter gson = new GsonConverter();
        String json = gson.toJson(this);
        transaction.setContext("task", json);
        try {
            FileWriter jsonFile = new FileWriter(Files.getTaskFile(this.id));
            jsonFile.write(json);
            jsonFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            transaction.setThrowable(e);
            transaction.setStatus(SpanStatus.INTERNAL_ERROR);
        }
        finally {
            transaction.finish();
        }
    }
}

