/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.field.DataPersisterManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import fr.minuskube.inv.InventoryManager;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import me.playbosswar.com.commands.MainCommand;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.conditionsengine.ConditionEngineManager;
import me.playbosswar.com.conditionsengine.EventsManager;
import me.playbosswar.com.events.JoinEvents;
import me.playbosswar.com.hooks.HooksManager;
import me.playbosswar.com.hooks.Metrics;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.scheduler.BukkitSchedulerAdapter;
import me.playbosswar.com.scheduler.FoliaSchedulerAdapter;
import me.playbosswar.com.scheduler.SchedulerAdapter;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TasksManager;
import me.playbosswar.com.tasks.persistors.ConditionPersistor;
import me.playbosswar.com.tasks.persistors.DaysPersistor;
import me.playbosswar.com.tasks.persistors.EventConfigurationPersistor;
import me.playbosswar.com.tasks.persistors.TaskCommandPersistor;
import me.playbosswar.com.tasks.persistors.TaskIntervalPersistor;
import me.playbosswar.com.tasks.persistors.TaskTimePersistor;
import me.playbosswar.com.updater.Updater;
import me.playbosswar.com.utils.Files;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.Tools;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CommandTimerPlugin
extends JavaPlugin
implements Listener {
    private static Plugin plugin;
    private static CommandTimerPlugin instance;
    private static HooksManager hooksManager;
    private static InventoryManager inventoryManager;
    private static TasksManager tasksManager;
    private static ConditionEngineManager conditionEngineManager;
    private static EventsManager eventsManager;
    public static Metrics metrics;
    public static Updater updater;
    public static LanguageManager languageManager;
    public static Dao<Task, Integer> taskDao;
    public static SchedulerAdapter schedulerAdapter;

    public void onEnable() {
        plugin = this;
        instance = this;
        this.loadConfig();
        languageManager = new LanguageManager((Plugin)this, this.getConfig().getString("language"));
        if (FoliaSchedulerAdapter.isSupported()) {
            schedulerAdapter = new FoliaSchedulerAdapter((Plugin)this);
            Messages.sendConsole("&eUsing Folia scheduler adapter");
        } else {
            schedulerAdapter = new BukkitSchedulerAdapter((Plugin)this);
            Messages.sendConsole("&eUsing Bukkit scheduler adapter");
        }
        Sentry.init(options -> {
            options.setDsn("https://45383fac83f64e65a45d83c3059eb934@o1414814.ingest.sentry.io/6755132");
            options.setTracesSampleRate(0.3);
            options.setRelease(this.getDescription().getVersion());
        });
        Sentry.configureScope(scope -> {
            scope.setExtra("bukkit_version", this.getServer().getBukkitVersion());
            scope.setExtra("server_name", this.getServer().getName());
        });
        ITransaction transaction = Sentry.startTransaction("server_startup", "initiation");
        this.registerCommands();
        Bukkit.getPluginManager().registerEvents((Listener)new JoinEvents(), (Plugin)this);
        Files.migrateFileNamesToFileUuids();
        if (this.getConfig().getBoolean("database.enabled")) {
            try {
                Class.forName("com.mysql.jdbc.Driver");
                JdbcConnectionSource connectionSource = new JdbcConnectionSource(this.getConfig().getString("database.url"));
                DataPersisterManager.registerDataPersisters(TaskCommandPersistor.getSingleton(), TaskIntervalPersistor.getSingleton(), TaskTimePersistor.getSingleton(), ConditionPersistor.getSingleton(), EventConfigurationPersistor.getSingleton(), DaysPersistor.getSingleton());
                taskDao = DaoManager.createDao((ConnectionSource)connectionSource, Task.class);
                TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, Task.class);
            }
            catch (ClassNotFoundException | SQLException e) {
                throw new RuntimeException(e);
            }
        }
        updater = new Updater((Plugin)this);
        metrics = new Metrics(CommandTimerPlugin.getPlugin(), 9657);
        hooksManager = new HooksManager();
        tasksManager = new TasksManager((Plugin)this);
        inventoryManager = new InventoryManager(this);
        conditionEngineManager = new ConditionEngineManager();
        eventsManager = new EventsManager(tasksManager);
        inventoryManager.init();
        this.getServer().getMessenger().registerOutgoingPluginChannel(plugin, "commandtimer:main");
        this.loadMetrics();
        if (this.getConfig().getBoolean("timeonload")) {
            Tools.printDate();
        }
        Messages.sendConsole("&e" + this.getDescription().getVersion() + "&a loaded " + this.getTasksManager().getLoadedTasks().size() + " tasks!");
        transaction.finish();
    }

    public void onDisable() {
        tasksManager.disable();
        conditionEngineManager.onDisable();
        this.saveDefaultConfig();
        plugin = null;
    }

    private void loadMetrics() {
        metrics.addCustomChart(new Metrics.SingleLineChart("loaded_tasks", () -> tasksManager.getLoadedTasks().size()));
        metrics.addCustomChart(new Metrics.SingleLineChart("executed_tasks", () -> {
            int v = CommandTimerPlugin.tasksManager.executionsSinceLastSync;
            CommandTimerPlugin.tasksManager.executionsSinceLastSync = 0;
            return v;
        }));
        metrics.addCustomChart(new Metrics.MultiLineChart("loaded_extensions", () -> {
            HashMap map = new HashMap();
            conditionEngineManager.getConditionExtensions().forEach(conditionExtension -> map.put(conditionExtension.getConditionGroupName(), 1));
            return map;
        }));
    }

    public void registerCommands() {
        this.getCommand("commandtimer").setExecutor((CommandExecutor)new MainCommand((Plugin)this));
    }

    public void loadConfig() {
        Files.createDataFolders();
        this.saveDefaultConfig();
        this.getConfig().options().copyDefaults(true);
        this.loadDefaults();
    }

    private void loadDefaults() {
        File existingConfigFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration existingFileConfiguration = YamlConfiguration.loadConfiguration((File)existingConfigFile);
        for (String section : this.getConfig().getConfigurationSection("").getKeys(true)) {
            if (existingFileConfiguration.get(section) != null) continue;
            existingFileConfiguration.set(section, this.getConfig().get(section));
        }
        try {
            existingFileConfiguration.save(existingConfigFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Plugin getPlugin() {
        return plugin;
    }

    public HooksManager getHooksManager() {
        return hooksManager;
    }

    public InventoryManager getInventoryManager() {
        return inventoryManager;
    }

    public TasksManager getTasksManager() {
        return tasksManager;
    }

    public void setTasksManager(TasksManager tasksManager) {
        CommandTimerPlugin.tasksManager = tasksManager;
    }

    public ConditionEngineManager getConditionEngineManager() {
        return conditionEngineManager;
    }

    public void setConditionEngineManager(ConditionEngineManager conditionEngineManager) {
        CommandTimerPlugin.conditionEngineManager = conditionEngineManager;
    }

    public EventsManager getEventsManager() {
        return eventsManager;
    }

    public Metrics getMetrics() {
        return metrics;
    }

    public static CommandTimerPlugin getInstance() {
        return instance;
    }

    public static Updater getUpdater() {
        return updater;
    }

    public static LanguageManager getLanguageManager() {
        return languageManager;
    }

    public static Dao<Task, Integer> getTaskDao() {
        return taskDao;
    }

    public static SchedulerAdapter getScheduler() {
        return schedulerAdapter;
    }
}

