/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.playbosswar.com.commandtimer.sentry.ISpan;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentrySpanStorage {
    @Nullable
    private static volatile SentrySpanStorage INSTANCE;
    @NotNull
    private final Map<String, ISpan> spans = new ConcurrentHashMap<String, ISpan>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static SentrySpanStorage getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<SentrySpanStorage> clazz = SentrySpanStorage.class;
        synchronized (SentrySpanStorage.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new SentrySpanStorage();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private SentrySpanStorage() {
    }

    public void store(@NotNull String spanId, @NotNull ISpan span) {
        this.spans.put(spanId, span);
    }

    @Nullable
    public ISpan get(@Nullable String spanId) {
        return this.spans.get(spanId);
    }

    @Nullable
    public ISpan removeAndGet(@Nullable String spanId) {
        return this.spans.remove(spanId);
    }
}

