/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.io.IOException;
import java.util.UUID;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.JsonObjectReader;
import me.playbosswar.com.commandtimer.sentry.JsonSerializable;
import me.playbosswar.com.commandtimer.sentry.ObjectWriter;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import me.playbosswar.com.commandtimer.sentry.util.StringUtils;
import org.jetbrains.annotations.NotNull;

public final class SpanId
implements JsonSerializable {
    public static final SpanId EMPTY_ID = new SpanId(new UUID(0L, 0L));
    @NotNull
    private final String value;

    public SpanId(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value is required");
    }

    public SpanId() {
        this(UUID.randomUUID());
    }

    private SpanId(@NotNull UUID uuid) {
        this(StringUtils.normalizeUUID(uuid.toString()).replace("-", "").substring(0, 16));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanId spanId = (SpanId)o;
        return this.value.equals(spanId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.value(this.value);
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanId> {
        @Override
        @NotNull
        public SpanId deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            return new SpanId(reader.nextString());
        }
    }
}

