/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.cache;

import java.util.Map;
import me.playbosswar.com.commandtimer.sentry.IOptionsObserver;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.cache.CacheUtils;
import me.playbosswar.com.commandtimer.sentry.protocol.SdkVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistingOptionsObserver
implements IOptionsObserver {
    public static final String OPTIONS_CACHE = ".options-cache";
    public static final String RELEASE_FILENAME = "release.json";
    public static final String PROGUARD_UUID_FILENAME = "proguard-uuid.json";
    public static final String SDK_VERSION_FILENAME = "sdk-version.json";
    public static final String ENVIRONMENT_FILENAME = "environment.json";
    public static final String DIST_FILENAME = "dist.json";
    public static final String TAGS_FILENAME = "tags.json";
    @NotNull
    private final SentryOptions options;

    public PersistingOptionsObserver(@NotNull SentryOptions options) {
        this.options = options;
    }

    private void serializeToDisk(@NotNull Runnable task) {
        try {
            this.options.getExecutorService().submit(() -> {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Serialization task failed", e);
                }
            });
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Serialization task could not be scheduled", e);
        }
    }

    @Override
    public void setRelease(@Nullable String release) {
        this.serializeToDisk(() -> {
            if (release == null) {
                this.delete(RELEASE_FILENAME);
            } else {
                this.store(release, RELEASE_FILENAME);
            }
        });
    }

    @Override
    public void setProguardUuid(@Nullable String proguardUuid) {
        this.serializeToDisk(() -> {
            if (proguardUuid == null) {
                this.delete(PROGUARD_UUID_FILENAME);
            } else {
                this.store(proguardUuid, PROGUARD_UUID_FILENAME);
            }
        });
    }

    @Override
    public void setSdkVersion(@Nullable SdkVersion sdkVersion) {
        this.serializeToDisk(() -> {
            if (sdkVersion == null) {
                this.delete(SDK_VERSION_FILENAME);
            } else {
                this.store(sdkVersion, SDK_VERSION_FILENAME);
            }
        });
    }

    @Override
    public void setDist(@Nullable String dist) {
        this.serializeToDisk(() -> {
            if (dist == null) {
                this.delete(DIST_FILENAME);
            } else {
                this.store(dist, DIST_FILENAME);
            }
        });
    }

    @Override
    public void setEnvironment(@Nullable String environment) {
        this.serializeToDisk(() -> {
            if (environment == null) {
                this.delete(ENVIRONMENT_FILENAME);
            } else {
                this.store(environment, ENVIRONMENT_FILENAME);
            }
        });
    }

    @Override
    public void setTags(@NotNull @NotNull Map<String, @NotNull String> tags) {
        this.serializeToDisk(() -> this.store(tags, TAGS_FILENAME));
    }

    private <T> void store(@NotNull T entity, @NotNull String fileName) {
        CacheUtils.store(this.options, entity, OPTIONS_CACHE, fileName);
    }

    private void delete(@NotNull String fileName) {
        CacheUtils.delete(this.options, OPTIONS_CACHE, fileName);
    }

    @Nullable
    public static <T> T read(@NotNull SentryOptions options, @NotNull String fileName, @NotNull Class<T> clazz) {
        return PersistingOptionsObserver.read(options, fileName, clazz, null);
    }

    @Nullable
    public static <T, R> T read(@NotNull SentryOptions options, @NotNull String fileName, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        return CacheUtils.read(options, OPTIONS_CACHE, fileName, clazz, elementDeserializer);
    }
}

