/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.clientreport;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import me.playbosswar.com.commandtimer.sentry.DataCategory;
import me.playbosswar.com.commandtimer.sentry.DateUtils;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelope;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelopeItem;
import me.playbosswar.com.commandtimer.sentry.SentryItemType;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.clientreport.AtomicClientReportStorage;
import me.playbosswar.com.commandtimer.sentry.clientreport.ClientReport;
import me.playbosswar.com.commandtimer.sentry.clientreport.ClientReportKey;
import me.playbosswar.com.commandtimer.sentry.clientreport.DiscardReason;
import me.playbosswar.com.commandtimer.sentry.clientreport.DiscardedEvent;
import me.playbosswar.com.commandtimer.sentry.clientreport.IClientReportRecorder;
import me.playbosswar.com.commandtimer.sentry.clientreport.IClientReportStorage;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ClientReportRecorder
implements IClientReportRecorder {
    @NotNull
    private final IClientReportStorage storage;
    @NotNull
    private final SentryOptions options;

    public ClientReportRecorder(@NotNull SentryOptions options) {
        this.options = options;
        this.storage = new AtomicClientReportStorage();
    }

    @Override
    @NotNull
    public SentryEnvelope attachReportToEnvelope(@NotNull SentryEnvelope envelope) {
        @Nullable ClientReport clientReport = this.resetCountsAndGenerateClientReport();
        if (clientReport == null) {
            return envelope;
        }
        try {
            this.options.getLogger().log(SentryLevel.DEBUG, "Attaching client report to envelope.", new Object[0]);
            ArrayList<SentryEnvelopeItem> items = new ArrayList<SentryEnvelopeItem>();
            for (SentryEnvelopeItem item : envelope.getItems()) {
                items.add(item);
            }
            items.add(SentryEnvelopeItem.fromClientReport(this.options.getSerializer(), clientReport));
            return new SentryEnvelope(envelope.getHeader(), items);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to attach client report to envelope.", new Object[0]);
            return envelope;
        }
    }

    @Override
    public void recordLostEnvelope(@NotNull DiscardReason reason, @Nullable SentryEnvelope envelope) {
        if (envelope == null) {
            return;
        }
        try {
            for (SentryEnvelopeItem item : envelope.getItems()) {
                this.recordLostEnvelopeItem(reason, item);
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost envelope.", new Object[0]);
        }
    }

    @Override
    public void recordLostEnvelopeItem(@NotNull DiscardReason reason, @Nullable SentryEnvelopeItem envelopeItem) {
        if (envelopeItem == null) {
            return;
        }
        try {
            @NotNull SentryItemType itemType = envelopeItem.getHeader().getType();
            if (SentryItemType.ClientReport.equals(itemType)) {
                try {
                    ClientReport clientReport = envelopeItem.getClientReport(this.options.getSerializer());
                    this.restoreCountsFromClientReport(clientReport);
                }
                catch (Exception e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Unable to restore counts from previous client report.", new Object[0]);
                }
            } else {
                this.recordLostEventInternal(reason.getReason(), this.categoryFromItemType(itemType).getCategory(), 1L);
            }
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost envelope item.", new Object[0]);
        }
    }

    @Override
    public void recordLostEvent(@NotNull DiscardReason reason, @NotNull DataCategory category) {
        try {
            this.recordLostEventInternal(reason.getReason(), category.getCategory(), 1L);
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, e, "Unable to record lost event.", new Object[0]);
        }
    }

    private void recordLostEventInternal(@NotNull String reason, @NotNull String category, @NotNull Long countToAdd) {
        ClientReportKey key = new ClientReportKey(reason, category);
        this.storage.addCount(key, countToAdd);
    }

    @Nullable
    ClientReport resetCountsAndGenerateClientReport() {
        Date currentDate = DateUtils.getCurrentDateTime();
        List<DiscardedEvent> discardedEvents = this.storage.resetCountsAndGet();
        if (discardedEvents.isEmpty()) {
            return null;
        }
        return new ClientReport(currentDate, discardedEvents);
    }

    private void restoreCountsFromClientReport(@Nullable ClientReport clientReport) {
        if (clientReport == null) {
            return;
        }
        for (DiscardedEvent discardedEvent : clientReport.getDiscardedEvents()) {
            this.recordLostEventInternal(discardedEvent.getReason(), discardedEvent.getCategory(), discardedEvent.getQuantity());
        }
    }

    private DataCategory categoryFromItemType(SentryItemType itemType) {
        if (SentryItemType.Event.equals(itemType)) {
            return DataCategory.Error;
        }
        if (SentryItemType.Session.equals(itemType)) {
            return DataCategory.Session;
        }
        if (SentryItemType.Transaction.equals(itemType)) {
            return DataCategory.Transaction;
        }
        if (SentryItemType.UserFeedback.equals(itemType)) {
            return DataCategory.UserReport;
        }
        if (SentryItemType.Profile.equals(itemType)) {
            return DataCategory.Profile;
        }
        if (SentryItemType.Attachment.equals(itemType)) {
            return DataCategory.Attachment;
        }
        return DataCategory.Default;
    }
}

