/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.protocol;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.playbosswar.com.commandtimer.sentry.DateUtils;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.JsonObjectReader;
import me.playbosswar.com.commandtimer.sentry.JsonSerializable;
import me.playbosswar.com.commandtimer.sentry.JsonUnknown;
import me.playbosswar.com.commandtimer.sentry.ObjectWriter;
import me.playbosswar.com.commandtimer.sentry.SentryBaseEvent;
import me.playbosswar.com.commandtimer.sentry.SentryTracer;
import me.playbosswar.com.commandtimer.sentry.Span;
import me.playbosswar.com.commandtimer.sentry.SpanContext;
import me.playbosswar.com.commandtimer.sentry.SpanStatus;
import me.playbosswar.com.commandtimer.sentry.TracesSamplingDecision;
import me.playbosswar.com.commandtimer.sentry.protocol.Contexts;
import me.playbosswar.com.commandtimer.sentry.protocol.MeasurementValue;
import me.playbosswar.com.commandtimer.sentry.protocol.SentrySpan;
import me.playbosswar.com.commandtimer.sentry.protocol.TransactionInfo;
import me.playbosswar.com.commandtimer.sentry.protocol.TransactionNameSource;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import me.playbosswar.com.commandtimer.sentry.vendor.gson.stream.JsonToken;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryTransaction
extends SentryBaseEvent
implements JsonUnknown,
JsonSerializable {
    @Nullable
    private String transaction;
    @NotNull
    private Double startTimestamp;
    @Nullable
    private Double timestamp;
    @NotNull
    private final List<SentrySpan> spans = new ArrayList<SentrySpan>();
    @NotNull
    private final String type = "transaction";
    @NotNull
    private final @NotNull Map<String, @NotNull MeasurementValue> measurements = new HashMap<String, MeasurementValue>();
    @NotNull
    private TransactionInfo transactionInfo;
    @Nullable
    private Map<String, Object> unknown;

    public SentryTransaction(@NotNull SentryTracer sentryTracer) {
        super(sentryTracer.getEventId());
        Objects.requireNonNull(sentryTracer, "sentryTracer is required");
        this.startTimestamp = DateUtils.nanosToSeconds(sentryTracer.getStartDate().nanoTimestamp());
        this.timestamp = DateUtils.nanosToSeconds(sentryTracer.getStartDate().laterDateNanosTimestampByDiff(sentryTracer.getFinishDate()));
        this.transaction = sentryTracer.getName();
        for (Span span : sentryTracer.getChildren()) {
            if (!Boolean.TRUE.equals(span.isSampled())) continue;
            this.spans.add(new SentrySpan(span));
        }
        Contexts contexts = this.getContexts();
        contexts.putAll(sentryTracer.getContexts());
        SpanContext tracerContext = sentryTracer.getSpanContext();
        contexts.setTrace(new SpanContext(tracerContext.getTraceId(), tracerContext.getSpanId(), tracerContext.getParentSpanId(), tracerContext.getOperation(), tracerContext.getDescription(), tracerContext.getSamplingDecision(), tracerContext.getStatus(), tracerContext.getOrigin()));
        for (Map.Entry<String, String> tag : tracerContext.getTags().entrySet()) {
            this.setTag(tag.getKey(), tag.getValue());
        }
        Map<String, Object> data = sentryTracer.getData();
        if (data != null) {
            for (Map.Entry<String, Object> tag : data.entrySet()) {
                this.setExtra(tag.getKey(), tag.getValue());
            }
        }
        this.transactionInfo = new TransactionInfo(sentryTracer.getTransactionNameSource().apiName());
    }

    @ApiStatus.Internal
    public SentryTransaction(@Nullable String transaction, @NotNull Double startTimestamp, @Nullable Double timestamp, @NotNull List<SentrySpan> spans, @NotNull @NotNull Map<String, @NotNull MeasurementValue> measurements, @NotNull TransactionInfo transactionInfo) {
        this.transaction = transaction;
        this.startTimestamp = startTimestamp;
        this.timestamp = timestamp;
        this.spans.addAll(spans);
        this.measurements.putAll(measurements);
        this.transactionInfo = transactionInfo;
    }

    @NotNull
    public List<SentrySpan> getSpans() {
        return this.spans;
    }

    public boolean isFinished() {
        return this.timestamp != null;
    }

    @Nullable
    public String getTransaction() {
        return this.transaction;
    }

    @NotNull
    public Double getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Double getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public String getType() {
        return "transaction";
    }

    @Nullable
    public SpanStatus getStatus() {
        SpanContext trace = this.getContexts().getTrace();
        return trace != null ? trace.getStatus() : null;
    }

    public boolean isSampled() {
        @Nullable TracesSamplingDecision samplingDecsion = this.getSamplingDecision();
        if (samplingDecsion == null) {
            return false;
        }
        return samplingDecsion.getSampled();
    }

    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        SpanContext trace = this.getContexts().getTrace();
        if (trace == null) {
            return null;
        }
        return trace.getSamplingDecision();
    }

    @NotNull
    public @NotNull Map<String, @NotNull MeasurementValue> getMeasurements() {
        return this.measurements;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        if (this.transaction != null) {
            writer.name("transaction").value(this.transaction);
        }
        writer.name("start_timestamp").value(logger, this.doubleToBigDecimal(this.startTimestamp));
        if (this.timestamp != null) {
            writer.name("timestamp").value(logger, this.doubleToBigDecimal(this.timestamp));
        }
        if (!this.spans.isEmpty()) {
            writer.name("spans").value(logger, this.spans);
        }
        writer.name("type").value("transaction");
        if (!this.measurements.isEmpty()) {
            writer.name("measurements").value(logger, this.measurements);
        }
        writer.name("transaction_info").value(logger, this.transactionInfo);
        new SentryBaseEvent.Serializer().serialize(this, writer, logger);
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        writer.endObject();
    }

    @NotNull
    private BigDecimal doubleToBigDecimal(@NotNull Double value) {
        return BigDecimal.valueOf(value).setScale(6, RoundingMode.DOWN);
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TRANSACTION = "transaction";
        public static final String START_TIMESTAMP = "start_timestamp";
        public static final String TIMESTAMP = "timestamp";
        public static final String SPANS = "spans";
        public static final String TYPE = "type";
        public static final String MEASUREMENTS = "measurements";
        public static final String TRANSACTION_INFO = "transaction_info";
    }

    public static final class Deserializer
    implements JsonDeserializer<SentryTransaction> {
        @Override
        @NotNull
        public SentryTransaction deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            reader.beginObject();
            SentryTransaction transaction = new SentryTransaction("", 0.0, null, new ArrayList<SentrySpan>(), new HashMap<String, MeasurementValue>(), new TransactionInfo(TransactionNameSource.CUSTOM.apiName()));
            ConcurrentHashMap<String, Object> unknown = null;
            SentryBaseEvent.Deserializer baseEventDeserializer = new SentryBaseEvent.Deserializer();
            block22: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "transaction": {
                        transaction.transaction = reader.nextStringOrNull();
                        break;
                    }
                    case "start_timestamp": {
                        Date date;
                        try {
                            Double deserializedStartTimestamp = reader.nextDoubleOrNull();
                            if (deserializedStartTimestamp == null) continue block22;
                            transaction.startTimestamp = deserializedStartTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            transaction.startTimestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "timestamp": {
                        Date date;
                        try {
                            Double deserializedTimestamp = reader.nextDoubleOrNull();
                            if (deserializedTimestamp == null) continue block22;
                            transaction.timestamp = deserializedTimestamp;
                        }
                        catch (NumberFormatException e) {
                            date = reader.nextDateOrNull(logger);
                            if (date == null) continue block22;
                            transaction.timestamp = DateUtils.dateToSeconds(date);
                        }
                        break;
                    }
                    case "spans": {
                        List<SentrySpan> deserializedSpans = reader.nextListOrNull(logger, new SentrySpan.Deserializer());
                        if (deserializedSpans == null) continue block22;
                        transaction.spans.addAll(deserializedSpans);
                        break;
                    }
                    case "type": {
                        reader.nextString();
                        break;
                    }
                    case "measurements": {
                        Map<String, MeasurementValue> deserializedMeasurements = reader.nextMapOrNull(logger, new MeasurementValue.Deserializer());
                        if (deserializedMeasurements == null) continue block22;
                        transaction.measurements.putAll(deserializedMeasurements);
                        break;
                    }
                    case "transaction_info": {
                        transaction.transactionInfo = new TransactionInfo.Deserializer().deserialize(reader, logger);
                        break;
                    }
                    default: {
                        if (baseEventDeserializer.deserializeValue(transaction, nextName, reader, logger)) continue block22;
                        if (unknown == null) {
                            unknown = new ConcurrentHashMap<String, Object>();
                        }
                        reader.nextUnknown(logger, unknown, nextName);
                    }
                }
            }
            transaction.setUnknown(unknown);
            reader.endObject();
            return transaction;
        }
    }
}

