/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.transport;

import java.io.IOException;
import me.playbosswar.com.commandtimer.sentry.Hint;
import me.playbosswar.com.commandtimer.sentry.ISerializer;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelope;
import me.playbosswar.com.commandtimer.sentry.transport.ITransport;
import me.playbosswar.com.commandtimer.sentry.transport.RateLimiter;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StdoutTransport
implements ITransport {
    @NotNull
    private final ISerializer serializer;

    public StdoutTransport(@NotNull ISerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer, "Serializer is required");
    }

    @Override
    public void send(@NotNull SentryEnvelope envelope, @NotNull Hint hint) throws IOException {
        Objects.requireNonNull(envelope, "SentryEnvelope is required");
        try {
            this.serializer.serialize(envelope, System.out);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void flush(long timeoutMillis) {
        System.out.println("Flushing");
    }

    @Override
    @Nullable
    public RateLimiter getRateLimiter() {
        return null;
    }

    @Override
    public void close() {
    }
}

