/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.general;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.util.ArrayList;
import java.util.UUID;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.api.GenericNumberMenu;
import me.playbosswar.com.gui.tasks.general.GeneralLimitsMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ExecutionLimitMenu
implements InventoryProvider {
    private final SmartInventory inventory;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;

    public ExecutionLimitMenu(Player player, Task task) {
        this.task = task;
        this.inventory = SmartInventory.builder().id(UUID.randomUUID().toString()).provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.TASK_EXECUTION_LIMIT_GUI_TITLE)).build();
        this.inventory.open(player);
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        ArrayList<String> limitLore = this.languageManager.getList(LanguageKey.TASK_EXECUTION_LIMIT_LORE);
        limitLore.add("");
        limitLore.add(this.languageManager.get(LanguageKey.GUI_CURRENT, String.valueOf(this.task.getExecutionLimit())));
        ItemStack limitItem = Items.generateItem("\u00a7bLimit", XMaterial.STICK, limitLore.toArray(new String[0]));
        ClickableItem clickableLimitItem = ClickableItem.of(limitItem, e -> new GenericNumberMenu(player, this.languageManager.get(LanguageKey.EXECUTION_LIMIT_NUMBER_GUI_TITLE), this.task.getExecutionLimit(), limit -> {
            this.task.setExecutionLimit((int)limit);
            this.inventory.open(player);
        }));
        contents.set(1, 1, clickableLimitItem);
        ItemStack toggleResetItem = Items.getToggleItem(LanguageKey.EXECUTION_LIMIT_RESET, this.languageManager.getList(LanguageKey.TOGGLE_RESET_LORE).toArray(new String[0]), this.task.isResetExecutionsAfterRestart());
        ClickableItem clickableToggleResetItem = ClickableItem.of(toggleResetItem, e -> {
            this.task.toggleResetExecutionAfterRestart();
            this.inventory.open(player);
        });
        contents.set(1, 2, clickableToggleResetItem);
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new GeneralLimitsMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

