/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.hooks;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.hooks.PlaceholderConfiguration;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.TaskTimeUtils;
import me.playbosswar.com.utils.Tools;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class PAPIPlaceholders
extends PlaceholderExpansion {
    private final Plugin plugin;

    public PAPIPlaceholders(Plugin p) {
        this.plugin = p;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "commandtimer";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        PlaceholderConfiguration placeholder = new PlaceholderConfiguration(identifier);
        if (!placeholder.isValid()) {
            Messages.sendConsole("Used a CommandTimer placeholder wrong. Example: %commandtimer_testtask_nextExecutionFormat%");
            return "INVALID PLACEHOLDER";
        }
        Task task = CommandTimerPlugin.getInstance().getTasksManager().getTaskByName(placeholder.getTaskName());
        String fallbackMessage = placeholder.getFallbackMessage();
        if (placeholder.getTaskName().equals("ALLTASKS")) {
            task = this.getSoonestTask(CommandTimerPlugin.getInstance().getTasksManager().getActiveTasks());
        }
        if (task == null) {
            if (CommandTimerPlugin.getInstance().getConfig().getBoolean("disablePapiPlaceholderWarnings")) {
                return fallbackMessage;
            }
            Messages.sendConsole("Tried to use PAPI placeholder for unknown task:" + placeholder.getTaskName());
            return fallbackMessage;
        }
        if (placeholder.getPlaceholderType().equals("nextTaskName")) {
            return task.getName();
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("seconds")) {
            return this.getSecondsText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("secondsFormat")) {
            return this.getSecondsText(task, fallbackMessage, true);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("nextExecution")) {
            return this.getNextExecutionText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("nextExecutionFormat")) {
            return this.getNextExecutionText(task, fallbackMessage, true);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("lastExecution")) {
            return this.getLastExecutionText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("lastExecutionFormat")) {
            return this.getLastExecutionText(task, fallbackMessage, true);
        }
        return this.getNextExecutionText(task, fallbackMessage, true, placeholder.getPlaceholderType());
    }

    private String getSecondsText(Task task, String fallbackMessage, boolean format) {
        int seconds = task.getInterval().toSeconds();
        if (seconds < 0 && fallbackMessage != null) {
            return fallbackMessage;
        }
        if (format) {
            return Tools.getTimeString(seconds);
        }
        return seconds + "";
    }

    private long getNextExecution(Task task) {
        long now = new Date().getTime();
        if (!task.getTimes().isEmpty()) {
            List rangeTimes = task.getTimes().stream().filter(t -> t.getTime2() != null).collect(Collectors.toList());
            Date date = TaskTimeUtils.getSoonestTaskTime(task, task.getTimes());
            if (rangeTimes.isEmpty()) {
                if (date == null || !task.isActive()) {
                    return -1L;
                }
                return (date.getTime() - now) / 1000L;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(now);
            int currentSeconds = cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13);
            ArrayList<TaskTime> applicableTimes = new ArrayList<TaskTime>();
            for (TaskTime rangeTime : rangeTimes) {
                int startSeconds = rangeTime.getTime1().getHour() * 3600 + rangeTime.getTime1().getMinute() * 60 + rangeTime.getTime1().getSecond();
                int endSeconds = rangeTime.getTime2().getHour() * 3600 + rangeTime.getTime2().getMinute() * 60 + rangeTime.getTime2().getSecond();
                if (endSeconds < startSeconds) {
                    if (currentSeconds < startSeconds && currentSeconds > endSeconds) continue;
                    applicableTimes.add(rangeTime);
                    continue;
                }
                if (currentSeconds < startSeconds || currentSeconds > endSeconds) continue;
                applicableTimes.add(rangeTime);
            }
            if (applicableTimes.isEmpty()) {
                if (date == null || !task.isActive()) {
                    return -1L;
                }
                return (date.getTime() - now) / 1000L;
            }
            Interval interval = new Interval(task.getLastExecuted().getTime(), now);
            Duration period = interval.toDuration();
            long timeLeft = (long)task.getInterval().toSeconds() - period.getStandardSeconds();
            if (timeLeft < 0L || !task.isActive()) {
                return -1L;
            }
            return timeLeft;
        }
        Interval interval = new Interval(task.getLastExecuted().getTime(), now);
        Duration period = interval.toDuration();
        long timeLeft = (long)task.getInterval().toSeconds() - period.getStandardSeconds();
        if (timeLeft < 0L || !task.isActive()) {
            return -1L;
        }
        return timeLeft;
    }

    private long getLastExecution(Task task) {
        if (task.getLastExecuted() == null || !task.isActive()) {
            return -1L;
        }
        long now = new Date().getTime();
        Interval interval = new Interval(task.getLastExecuted().getTime(), now);
        Duration period = interval.toDuration();
        return period.getStandardSeconds();
    }

    private String getNextExecutionText(Task task, String fallbackMessage, boolean format, String timeFormat) {
        long seconds = this.getNextExecution(task);
        if (seconds == -1L) {
            return fallbackMessage != null ? fallbackMessage : "";
        }
        if (format) {
            return Tools.getTimeString((int)seconds, timeFormat);
        }
        return seconds + "";
    }

    private String getLastExecutionText(Task task, String fallbackMessage, boolean format, String timeFormat) {
        long seconds = this.getLastExecution(task);
        if (seconds == -1L) {
            return fallbackMessage != null ? fallbackMessage : "";
        }
        if (format) {
            return Tools.getTimeString((int)seconds, timeFormat);
        }
        return seconds + "";
    }

    private String getNextExecutionText(Task task, String fallbackMessage, boolean format) {
        return this.getNextExecutionText(task, fallbackMessage, format, "HH:mm:ss");
    }

    private String getLastExecutionText(Task task, String fallbackMessage, boolean format) {
        return this.getLastExecutionText(task, fallbackMessage, format, "HH:mm:ss");
    }

    private Task getSoonestTask(List<Task> tasks) {
        HashMap timeTillExecution = new HashMap();
        tasks.forEach(t -> {
            long seconds = this.getNextExecution((Task)t);
            if (seconds > 0L) {
                timeTillExecution.put(t, seconds);
            }
        });
        if (timeTillExecution.isEmpty()) {
            return null;
        }
        return (Task)Collections.min(timeTillExecution.entrySet(), Map.Entry.comparingByValue()).getKey();
    }
}

