/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.scheduler;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.playbosswar.com.scheduler.SchedulerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.Nullable;

public class FoliaSchedulerAdapter
implements SchedulerAdapter {
    private static final boolean SUPPORTED;
    private static final boolean HAS_IS_CANCELLED;
    @Nullable
    private static MethodHandle ASYNC_SCHEDULER_RUN;
    @Nullable
    private static MethodHandle ASYNC_SCHEDULER_RUN_DELAYED;
    @Nullable
    private static MethodHandle ASYNC_SCHEDULER_RUN_RATE;
    @Nullable
    private static MethodHandle SCHEDULED_TASK_IS_CANCELLED;
    @Nullable
    private static MethodHandle SCHEDULED_TASK_CANCEL;
    private final Plugin plugin;

    public FoliaSchedulerAdapter(Plugin plugin) {
        this.plugin = plugin;
    }

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @Override
    public BukkitTask runTaskTimer(Runnable runnable, long delay, long period) {
        try {
            Consumer<Object> consumer = task -> runnable.run();
            return new ScheduledTask(Objects.requireNonNull(ASYNC_SCHEDULER_RUN_RATE).invoke(this.plugin, consumer, delay, period));
        }
        catch (Throwable e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error in task scheduling by the Folia scheduler adapter", e);
            return new ScheduledTask(null);
        }
    }

    @Override
    public BukkitTask runTask(Runnable runnable) {
        try {
            Consumer<Object> consumer = task -> runnable.run();
            return new ScheduledTask(Objects.requireNonNull(ASYNC_SCHEDULER_RUN).invoke(this.plugin, consumer));
        }
        catch (Throwable e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error in task scheduling by the Folia scheduler adapter", e);
            return new ScheduledTask(null);
        }
    }

    @Override
    public BukkitTask runTaskLater(Runnable runnable, long delay) {
        try {
            Consumer<Object> consumer = task -> runnable.run();
            return new ScheduledTask(Objects.requireNonNull(ASYNC_SCHEDULER_RUN_DELAYED).invoke(this.plugin, consumer, delay));
        }
        catch (Throwable e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error in task scheduling by the Folia scheduler adapter", e);
            return new ScheduledTask(null);
        }
    }

    @Override
    public BukkitTask runTaskAsynchronously(Runnable runnable) {
        return this.runTask(runnable);
    }

    static {
        boolean supporting = true;
        boolean hasMethod = false;
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            Class<?> scheduledTaskType = Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
            SCHEDULED_TASK_CANCEL = lookup.findVirtual(scheduledTaskType, "cancel", MethodType.methodType(Class.forName("io.papermc.paper.threadedregions.scheduler.ScheduledTask$CancelledState")));
            SCHEDULED_TASK_IS_CANCELLED = lookup.findVirtual(scheduledTaskType, "isCancelled", MethodType.methodType(Boolean.TYPE));
            Class<?> asyncSchedulerType = Class.forName("io.papermc.paper.threadedregions.scheduler.GlobalRegionScheduler");
            MethodHandle getAsyncScheduler = lookup.findVirtual(Server.class, "getGlobalRegionScheduler", MethodType.methodType(asyncSchedulerType));
            Object asyncScheduler = getAsyncScheduler.invoke(Bukkit.getServer());
            ASYNC_SCHEDULER_RUN = lookup.findVirtual(asyncSchedulerType, "run", MethodType.methodType(scheduledTaskType, Plugin.class, Consumer.class)).bindTo(asyncScheduler);
            ASYNC_SCHEDULER_RUN_DELAYED = lookup.findVirtual(asyncSchedulerType, "runDelayed", MethodType.methodType(scheduledTaskType, Plugin.class, Consumer.class, Long.TYPE)).bindTo(asyncScheduler);
            ASYNC_SCHEDULER_RUN_RATE = lookup.findVirtual(asyncSchedulerType, "runAtFixedRate", MethodType.methodType(scheduledTaskType, Plugin.class, Consumer.class, Long.TYPE, Long.TYPE)).bindTo(asyncScheduler);
            try {
                BukkitTask.class.getMethod("isCancelled", new Class[0]);
                hasMethod = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            supporting = false;
        }
        catch (Throwable throwable) {
            Logger.getLogger(FoliaSchedulerAdapter.class.getName()).log(Level.WARNING, "Error in Folia scheduler adapter initialization", throwable);
        }
        SUPPORTED = supporting;
        HAS_IS_CANCELLED = hasMethod;
    }

    private class ScheduledTask
    implements BukkitTask {
        private final Object task;

        public ScheduledTask(Object task) {
            this.task = task;
        }

        public int getTaskId() {
            return 0;
        }

        public Plugin getOwner() {
            return null;
        }

        public boolean isSync() {
            return false;
        }

        public boolean isCancelled() {
            if (!HAS_IS_CANCELLED) {
                return false;
            }
            try {
                return Objects.requireNonNull(SCHEDULED_TASK_IS_CANCELLED).invoke(this.task);
            }
            catch (Throwable e) {
                FoliaSchedulerAdapter.this.plugin.getLogger().log(Level.SEVERE, "Error in task cancellation check by the Folia scheduler adapter", e);
                return false;
            }
        }

        public void cancel() {
            try {
                Objects.requireNonNull(SCHEDULED_TASK_CANCEL).invoke(this.task);
            }
            catch (Throwable e) {
                FoliaSchedulerAdapter.this.plugin.getLogger().log(Level.SEVERE, "Error in task canceling by the Folia scheduler adapter", e);
            }
        }
    }
}

