/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.enums.Gender;
import me.playbosswar.com.hooks.PAPIHook;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskRunner;
import me.playbosswar.com.tasks.TaskValidationHelpers;
import me.playbosswar.com.utils.DatabaseUtils;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.StringEnhancer;
import me.playbosswar.com.utils.Tools;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class TasksManager {
    private static final String CONDITION_NO_MATCH = "Conditions did not match";
    private static final Random RANDOM = new Random();
    private static final String ALPHA_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private List<Task> loadedTasks = new ArrayList<Task>();
    private Thread runnerThread;
    public boolean stopRunner = false;
    public int executionsSinceLastSync = 0;

    public TasksManager(Plugin plugin) {
        if (plugin.getConfig().getBoolean("database.enabled")) {
            try {
                Messages.sendConsole("Loading all tasks from database");
                List<Task> tasks = DatabaseUtils.getAllTasksFromDatabase();
                this.loadedTasks.addAll(tasks);
                Messages.sendConsole("Loaded " + this.loadedTasks.size() + " tasks from database");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            this.loadedTasks.addAll(me.playbosswar.com.utils.Files.deserializeJsonFilesIntoCommandTimers());
        }
        this.loadedTasks.forEach(task -> {
            if (task.isResetExecutionsAfterRestart()) {
                task.setTimesExecuted(0);
                task.setLastExecuted(new Date());
                task.storeInstance();
            }
        });
        this.startRunner();
    }

    public Task createTask() {
        String name = "Task_" + TasksManager.generateRandomAlphabetic(4);
        Task task = new Task(name);
        this.loadedTasks.add(task);
        return task;
    }

    private static String generateRandomAlphabetic(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHA_CHARS.charAt(RANDOM.nextInt(ALPHA_CHARS.length())));
        }
        return sb.toString();
    }

    @Nullable
    public Task getTaskByName(String name) {
        Optional<Task> optionalTask = this.loadedTasks.stream().filter(task -> task.getName().equalsIgnoreCase(name)).findFirst();
        return optionalTask.orElse(null);
    }

    public void removeTask(Task task) throws IOException {
        if (CommandTimerPlugin.getPlugin().getConfig().getBoolean("database.enabled")) {
            try {
                CommandTimerPlugin.getTaskDao().delete(task);
                Files.delete(Paths.get(me.playbosswar.com.utils.Files.getTaskLocalExecutionFile(task.getId()), new String[0]));
                this.loadedTasks.remove(task);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Files.delete(Paths.get(me.playbosswar.com.utils.Files.getTaskFile(task.getId()), new String[0]));
                this.loadedTasks.remove(task);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<Task> getLoadedTasks() {
        return this.loadedTasks;
    }

    public List<Task> getActiveTasks() {
        return this.loadedTasks.stream().filter(Task::isActive).collect(Collectors.toList());
    }

    public void setLoadedTasks(List<Task> loadedTasks) {
        this.loadedTasks = loadedTasks;
    }

    private void startRunner() {
        TaskRunner runner = new TaskRunner(this);
        Thread thread = new Thread(runner);
        thread.start();
        this.runnerThread = thread;
    }

    private boolean runConsolePerUserCommand(Task task, TaskCommand taskCommand, List<UUID> scopedPlayers) throws CommandException {
        String command = taskCommand.getCommand();
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (!scopedPlayers.isEmpty()) {
            affectedPlayers = scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecutions = taskCommand.getInterval().toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            boolean valid;
            if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), (OfflinePlayer)p))) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            willExecute = true;
            if (delayedExecutions) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                    ++this.executionsSinceLastSync;
                }, 20L * (long)i * (long)taskCommand.getInterval().toSeconds() + 1L);
            } else {
                CommandTimerPlugin.getScheduler().runTask(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, (OfflinePlayer)p)));
                ++this.executionsSinceLastSync;
            }
            ++i;
        }
        return willExecute;
    }

    private boolean runConsolePerUserOfflineCommand(Task task, TaskCommand taskCommand) throws CommandException {
        String command = taskCommand.getCommand();
        boolean delayedExecutions = taskCommand.getInterval().toSeconds() > 0;
        int i = 0;
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            boolean valid;
            if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), p))) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            if (delayedExecutions) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> {
                    CommandTimerPlugin.getScheduler().runTask(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, p)));
                    ++this.executionsSinceLastSync;
                }, 20L * (long)i * (long)taskCommand.getInterval().toSeconds() + 1L);
            } else {
                CommandTimerPlugin.getScheduler().runTask(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, p)));
                ++this.executionsSinceLastSync;
            }
            ++i;
        }
        return true;
    }

    private boolean runConsolePerUserCommand(Task task, TaskCommand taskCommand) throws CommandException {
        return this.runConsolePerUserCommand(task, taskCommand, new ArrayList<UUID>());
    }

    private boolean runConsoleCommand(Task task, TaskCommand taskCommand) throws CommandException {
        boolean valid;
        if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), null))) {
            Messages.sendDebugConsole(CONDITION_NO_MATCH);
            return false;
        }
        String command = taskCommand.getCommand();
        CommandTimerPlugin.getScheduler().runTask(() -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, null)));
        ++this.executionsSinceLastSync;
        return true;
    }

    private boolean runPlayerCommand(Task task, TaskCommand taskCommand, List<UUID> scopedPlayers) {
        String command = taskCommand.getCommand();
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (!scopedPlayers.isEmpty()) {
            affectedPlayers = scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecution = taskCommand.getInterval().toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            boolean valid;
            if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), (OfflinePlayer)p))) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            willExecute = true;
            if (delayedExecution) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> this.runForPlayer(p, command), 20L * (long)i * (long)taskCommand.getInterval().toSeconds() + 1L);
            } else {
                this.runForPlayer(p, command);
            }
            ++i;
        }
        return willExecute;
    }

    private void runForPlayer(Player p, String command) {
        String parsedCommand = PAPIHook.parsePAPI(command, (OfflinePlayer)p);
        CommandTimerPlugin.getScheduler().runTask(() -> {
            boolean executed = p.performCommand(parsedCommand);
            if (!executed) {
                String errorMessage = new StringEnhancer("Failed to execute command {command}").add("taskName", command).parse();
                throw new CommandException(errorMessage);
            }
            ++this.executionsSinceLastSync;
        });
    }

    private boolean runPlayerCommand(Task task, TaskCommand taskCommand) {
        return this.runPlayerCommand(task, taskCommand, new ArrayList<UUID>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runOperatorCommand(Task task, TaskCommand taskCommand, List<UUID> scopedPlayers) {
        String command = taskCommand.getCommand();
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (!scopedPlayers.isEmpty()) {
            affectedPlayers = scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecutions = taskCommand.getInterval().toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            boolean wasAlreadyOp = p.isOp();
            try {
                boolean valid;
                p.setOp(true);
                if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), (OfflinePlayer)p))) {
                    Messages.sendDebugConsole(CONDITION_NO_MATCH);
                    if (wasAlreadyOp) continue;
                    p.setOp(false);
                    continue;
                }
                willExecute = true;
                if (delayedExecutions) {
                    CommandTimerPlugin.getScheduler().runTaskLater(() -> {
                        p.performCommand(PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                        ++this.executionsSinceLastSync;
                    }, 20L * (long)i * (long)taskCommand.getInterval().toSeconds() + 1L);
                } else {
                    CommandTimerPlugin.getScheduler().runTask(() -> p.performCommand(PAPIHook.parsePAPI(command, (OfflinePlayer)p)));
                    ++this.executionsSinceLastSync;
                }
            }
            finally {
                if (wasAlreadyOp) continue;
                p.setOp(false);
                continue;
            }
            ++i;
        }
        return willExecute;
    }

    private boolean runOperatorCommand(Task task, TaskCommand taskCommand) {
        return this.runOperatorCommand(task, taskCommand, new ArrayList<UUID>());
    }

    private boolean runConsoleProxyCommand(Task task, TaskCommand taskCommand) {
        boolean valid;
        if (task.hasCondition() && !(valid = TaskValidationHelpers.processCondition(task.getCondition(), null))) {
            Messages.sendDebugConsole(CONDITION_NO_MATCH);
            return false;
        }
        String command = taskCommand.getCommand();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("executeConsoleCommand");
            out.writeUTF(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getServer().sendPluginMessage(CommandTimerPlugin.getPlugin(), "commandtimer:main", b.toByteArray());
        ++this.executionsSinceLastSync;
        return true;
    }

    public void processCommandExecution(Task task, TaskCommand taskCommand) {
        if (!task.isActive()) {
            return;
        }
        CommandTimerPlugin.getScheduler().runTaskAsynchronously(() -> {
            Gender gender = taskCommand.getGender();
            boolean executed = false;
            if (gender.equals((Object)Gender.CONSOLE)) {
                executed = this.runConsoleCommand(task, taskCommand);
            } else if (gender.equals((Object)Gender.PLAYER)) {
                executed = this.runPlayerCommand(task, taskCommand);
            } else if (gender.equals((Object)Gender.OPERATOR)) {
                executed = this.runOperatorCommand(task, taskCommand);
            } else if (gender.equals((Object)Gender.CONSOLE_PER_USER)) {
                executed = this.runConsolePerUserCommand(task, taskCommand);
            } else if (gender.equals((Object)Gender.CONSOLE_PER_USER_OFFLINE)) {
                executed = this.runConsolePerUserOfflineCommand(task, taskCommand);
            } else if (gender.equals((Object)Gender.CONSOLE_PROXY)) {
                executed = this.runConsoleProxyCommand(task, taskCommand);
            }
            if (executed) {
                task.setLastExecuted(new Date());
                task.setTimesExecuted(task.getTimesExecuted() + 1);
                task.storeInstance();
            }
        });
    }

    public int getNextTaskCommandIndex(Task task) {
        int selectedCommandIndex = -1;
        if (task.getCommandExecutionMode().equals((Object)CommandExecutionMode.RANDOM)) {
            selectedCommandIndex = Tools.getRandomInt(0, task.getCommands().size() - 1);
        } else if (task.getCommandExecutionMode().equals((Object)CommandExecutionMode.ORDERED)) {
            int currentLatestCommandIndex = task.getLastExecutedCommandIndex();
            selectedCommandIndex = currentLatestCommandIndex >= task.getCommands().size() - 1 ? 0 : currentLatestCommandIndex + 1;
        }
        return selectedCommandIndex;
    }

    public void disable() {
        List<Task> tasksToStore = this.loadedTasks.stream().filter(Task::isActive).collect(Collectors.toList());
        tasksToStore.forEach(Task::storeInstance);
        this.stopRunner = true;
        if (this.runnerThread != null && this.runnerThread.isAlive()) {
            this.runnerThread.interrupt();
        }
    }
}

