/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskTime;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class TaskTimeUtils {
    @Nullable
    public static Date getSoonestTaskTime(Task task, List<TaskTime> taskTimes) {
        ArrayList dates = new ArrayList();
        taskTimes.forEach(taskTime -> {
            Calendar cal = Calendar.getInstance();
            for (int i = 0; i <= 30; ++i) {
                if (i != 0) {
                    cal.add(6, 1);
                }
                task.getDays().forEach(day -> {
                    if (cal.get(7) != TaskTimeUtils.transformDow(day)) {
                        return;
                    }
                    cal.set(11, taskTime.getTime1().getHour());
                    cal.set(12, taskTime.getTime1().getMinute());
                    cal.set(13, taskTime.getTime1().getSecond());
                    dates.add(cal.getTime());
                });
            }
        });
        if (dates.size() == 0) {
            return null;
        }
        long now = System.currentTimeMillis();
        List futureDates = dates.stream().filter(date -> date.getTime() >= now).collect(Collectors.toList());
        if (futureDates.size() == 0) {
            return null;
        }
        return (Date)Collections.min(futureDates, (d1, d2) -> {
            long diff1 = Math.abs(d1.getTime() - now);
            long diff2 = Math.abs(d2.getTime() - now);
            return Long.compare(diff1, diff2);
        });
    }

    public static boolean hasPassedInterval(Task task) {
        try {
            Interval interval = new Interval(task.getLastExecuted().getTime(), new Date().getTime());
            Duration period = interval.toDuration();
            return period.getStandardSeconds() >= (long)task.getInterval().toSeconds();
        }
        catch (IllegalArgumentException e) {
            Bukkit.getLogger().log(Level.SEVERE, "Last executed time seems to be in the future!");
            e.printStackTrace();
            return false;
        }
    }

    private static int transformDow(DayOfWeek dow) {
        switch (dow) {
            case MONDAY: {
                return 2;
            }
            case TUESDAY: {
                return 3;
            }
            case WEDNESDAY: {
                return 4;
            }
            case THURSDAY: {
                return 5;
            }
            case FRIDAY: {
                return 6;
            }
            case SATURDAY: {
                return 7;
            }
            case SUNDAY: {
                return 1;
            }
        }
        return 0;
    }
}

