/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.playbosswar.com.utils.Messages;
import org.bukkit.World;
import org.joda.time.Duration;

public class Tools {
    public static void printDate() {
        LocalDate date = LocalDate.now();
        DayOfWeek dow = date.getDayOfWeek();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        Messages.sendConsole("&aServer time :&e " + time);
        Messages.sendConsole("&aServer day :&e " + dow);
    }

    public static boolean randomCheck(double random) {
        Random r = new Random();
        float chance = r.nextFloat();
        return (double)chance <= random;
    }

    public static int getRandomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static String calculateWorldTime(World w) {
        if (w == null) {
            return "00:00";
        }
        long gameTime = w.getTime();
        long hours = gameTime / 1000L + 6L;
        long minutes = gameTime % 1000L * 60L / 1000L;
        if (hours == 0L) {
            hours = 12L;
        }
        if (hours >= 24L) {
            hours -= 24L;
        }
        String mm = "0" + minutes;
        mm = mm.substring(mm.length() - 2);
        String realHours = String.valueOf(hours);
        if (hours < 10L) {
            realHours = "0" + realHours;
        }
        return realHours + ":" + mm;
    }

    private static String getTimeStringLegacy(int seconds, String format) {
        LocalDateTime local = LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneId.of("GMT"));
        return local.format(DateTimeFormatter.ofPattern(format));
    }

    public static String getTimeString(int seconds, String format) {
        if (!format.contains("DD")) {
            return Tools.getTimeStringLegacy(seconds, format);
        }
        Duration duration = Duration.standardSeconds(seconds);
        int days = (int)duration.getStandardDays();
        int hours = (int)(duration.getStandardHours() % 24L);
        int minutes = (int)(duration.getStandardMinutes() % 60L);
        int remainingSeconds = (int)(duration.getStandardSeconds() % 60L);
        return format.replace("DD", String.format("%02d", days)).replace("HH", String.format("%02d", hours)).replace("mm", String.format("%02d", minutes)).replace("ss", String.format("%02d", remainingSeconds));
    }

    private static String getTenthNumeric(long val) {
        if (val < 9L) {
            return "0" + val;
        }
        return val + "";
    }

    public static String getTimeString(int seconds) {
        int day = (int)TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) - (long)day * 24L;
        long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        if (day > 0) {
            return Tools.getTenthNumeric(day) + ":" + Tools.getTenthNumeric(hours) + ":" + Tools.getTenthNumeric(minute) + ":" + Tools.getTenthNumeric(second);
        }
        return Tools.getTenthNumeric(hours) + ":" + Tools.getTenthNumeric(minute) + ":" + Tools.getTenthNumeric(second);
    }
}

