/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class GsonDate
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    private final String FORMAT = "yyyy-MM-dd'T'HH:mm:ss. SSSXXX";

    public Date deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        List<SimpleDateFormat> formats = Arrays.asList(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss. SSSXXX"), new SimpleDateFormat("MMM d, yyyy, H:mm:ss a"), new SimpleDateFormat("MMM d, yyyy, HH:mm:ss a"), new SimpleDateFormat("MMM d, yyyy, HH:mm:ss"), new SimpleDateFormat("MMM d, yyyy, hh:mm:ss a"));
        for (SimpleDateFormat dataFormat : formats) {
            try {
                return dataFormat.parse(jsonElement.getAsString());
            }
            catch (ParseException parseException) {
            }
        }
        throw new JsonParseException("Can not parse data: " + jsonElement.getAsString());
    }

    public JsonElement serialize(Date date, Type type, JsonSerializationContext jsonSerializationContext) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss. SSSXXX");
        return new JsonPrimitive(sdf.format(date));
    }
}

