/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import me.playbosswar.com.commandtimer.sentry.Baggage;
import me.playbosswar.com.commandtimer.sentry.Instrumenter;
import me.playbosswar.com.commandtimer.sentry.PropagationContext;
import me.playbosswar.com.commandtimer.sentry.SentryTraceHeader;
import me.playbosswar.com.commandtimer.sentry.SpanContext;
import me.playbosswar.com.commandtimer.sentry.SpanId;
import me.playbosswar.com.commandtimer.sentry.TracesSamplingDecision;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryId;
import me.playbosswar.com.commandtimer.sentry.protocol.TransactionNameSource;
import me.playbosswar.com.commandtimer.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TransactionContext
extends SpanContext {
    @NotNull
    private static final String DEFAULT_NAME = "<unlabeled transaction>";
    @NotNull
    private static final TransactionNameSource DEFAULT_NAME_SOURCE = TransactionNameSource.CUSTOM;
    @NotNull
    private static final String DEFAULT_OPERATION = "default";
    @NotNull
    private String name;
    @NotNull
    private TransactionNameSource transactionNameSource;
    @Nullable
    private TracesSamplingDecision parentSamplingDecision;
    @Nullable
    private Baggage baggage;
    @NotNull
    private Instrumenter instrumenter = Instrumenter.SENTRY;

    @Deprecated
    @NotNull
    public static TransactionContext fromSentryTrace(@NotNull String name, @NotNull String operation, @NotNull SentryTraceHeader sentryTrace) {
        @Nullable Boolean parentSampled = sentryTrace.isSampled();
        TracesSamplingDecision samplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
        TransactionContext transactionContext = new TransactionContext(sentryTrace.getTraceId(), new SpanId(), sentryTrace.getSpanId(), samplingDecision, null);
        transactionContext.setName(name);
        transactionContext.setTransactionNameSource(TransactionNameSource.CUSTOM);
        transactionContext.setOperation(operation);
        return transactionContext;
    }

    @ApiStatus.Internal
    public static TransactionContext fromPropagationContext(@NotNull PropagationContext propagationContext) {
        @Nullable Boolean parentSampled = propagationContext.isSampled();
        TracesSamplingDecision samplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
        @Nullable Baggage baggage = propagationContext.getBaggage();
        if (baggage != null) {
            baggage.freeze();
            Double sampleRate = baggage.getSampleRateDouble();
            Boolean sampled = parentSampled != null ? parentSampled : false;
            samplingDecision = sampleRate != null ? new TracesSamplingDecision(sampled, sampleRate) : new TracesSamplingDecision(sampled);
        }
        return new TransactionContext(propagationContext.getTraceId(), propagationContext.getSpanId(), propagationContext.getParentSpanId(), samplingDecision, baggage);
    }

    public TransactionContext(@NotNull String name, @NotNull String operation) {
        this(name, operation, null);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation) {
        this(name, transactionNameSource, operation, null);
    }

    public TransactionContext(@NotNull String name, @NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        this(name, TransactionNameSource.CUSTOM, operation, samplingDecision);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull String name, @NotNull TransactionNameSource transactionNameSource, @NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        super(operation);
        this.name = Objects.requireNonNull(name, "name is required");
        this.transactionNameSource = transactionNameSource;
        this.setSamplingDecision(samplingDecision);
    }

    @ApiStatus.Internal
    public TransactionContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable SpanId parentSpanId, @Nullable TracesSamplingDecision parentSamplingDecision, @Nullable Baggage baggage) {
        super(traceId, spanId, DEFAULT_OPERATION, parentSpanId, null);
        this.name = DEFAULT_NAME;
        this.parentSamplingDecision = parentSamplingDecision;
        this.transactionNameSource = DEFAULT_NAME_SOURCE;
        this.baggage = baggage;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Boolean getParentSampled() {
        if (this.parentSamplingDecision == null) {
            return null;
        }
        return this.parentSamplingDecision.getSampled();
    }

    @Nullable
    public TracesSamplingDecision getParentSamplingDecision() {
        return this.parentSamplingDecision;
    }

    @Nullable
    public Baggage getBaggage() {
        return this.baggage;
    }

    public void setParentSampled(@Nullable Boolean parentSampled) {
        this.parentSamplingDecision = parentSampled == null ? null : new TracesSamplingDecision(parentSampled);
    }

    public void setParentSampled(@Nullable Boolean parentSampled, @Nullable Boolean parentProfileSampled) {
        this.parentSamplingDecision = parentSampled == null ? null : (parentProfileSampled == null ? new TracesSamplingDecision(parentSampled) : new TracesSamplingDecision(parentSampled, null, parentProfileSampled, null));
    }

    @NotNull
    public TransactionNameSource getTransactionNameSource() {
        return this.transactionNameSource;
    }

    @NotNull
    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public void setInstrumenter(@NotNull Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
    }

    public void setName(@NotNull String name) {
        this.name = Objects.requireNonNull(name, "name is required");
    }

    public void setTransactionNameSource(@NotNull TransactionNameSource transactionNameSource) {
        this.transactionNameSource = transactionNameSource;
    }
}

