/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.util;

import java.util.List;
import me.playbosswar.com.commandtimer.sentry.Baggage;
import me.playbosswar.com.commandtimer.sentry.BaggageHeader;
import me.playbosswar.com.commandtimer.sentry.IHub;
import me.playbosswar.com.commandtimer.sentry.IScope;
import me.playbosswar.com.commandtimer.sentry.ISpan;
import me.playbosswar.com.commandtimer.sentry.PropagationContext;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.SentryTraceHeader;
import me.playbosswar.com.commandtimer.sentry.util.PropagationTargetsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TracingUtils {
    public static void startNewTrace(@NotNull IHub hub) {
        hub.configureScope(scope -> scope.withPropagationContext(propagationContext -> scope.setPropagationContext(new PropagationContext())));
    }

    @Nullable
    public static TracingHeaders traceIfAllowed(@NotNull IHub hub, @NotNull String requestUrl, @Nullable List<String> thirdPartyBaggageHeaders, @Nullable ISpan span) {
        @NotNull SentryOptions sentryOptions = hub.getOptions();
        if (sentryOptions.isTraceSampling() && TracingUtils.shouldAttachTracingHeaders(requestUrl, sentryOptions)) {
            return TracingUtils.trace(hub, thirdPartyBaggageHeaders, span);
        }
        return null;
    }

    @Nullable
    public static TracingHeaders trace(@NotNull IHub hub, @Nullable List<String> thirdPartyBaggageHeaders, @Nullable ISpan span) {
        @NotNull SentryOptions sentryOptions = hub.getOptions();
        if (span != null && !span.isNoOp()) {
            return new TracingHeaders(span.toSentryTrace(), span.toBaggageHeader(thirdPartyBaggageHeaders));
        }
        @NotNull PropagationContextHolder returnValue = new PropagationContextHolder();
        hub.configureScope(scope -> returnValue.propagationContext = TracingUtils.maybeUpdateBaggage(scope, sentryOptions));
        if (returnValue.propagationContext != null) {
            @NotNull PropagationContext propagationContext = returnValue.propagationContext;
            @Nullable Baggage baggage = propagationContext.getBaggage();
            BaggageHeader baggageHeader = null;
            if (baggage != null) {
                baggageHeader = BaggageHeader.fromBaggageAndOutgoingHeader(baggage, thirdPartyBaggageHeaders);
            }
            return new TracingHeaders(new SentryTraceHeader(propagationContext.getTraceId(), propagationContext.getSpanId(), null), baggageHeader);
        }
        return null;
    }

    @NotNull
    public static PropagationContext maybeUpdateBaggage(@NotNull IScope scope, @NotNull SentryOptions sentryOptions) {
        return scope.withPropagationContext(propagationContext -> {
            @Nullable Baggage baggage = propagationContext.getBaggage();
            if (baggage == null) {
                baggage = new Baggage(sentryOptions.getLogger());
                propagationContext.setBaggage(baggage);
            }
            if (baggage.isMutable()) {
                baggage.setValuesFromScope(scope, sentryOptions);
                baggage.freeze();
            }
        });
    }

    private static boolean shouldAttachTracingHeaders(@NotNull String requestUrl, @NotNull SentryOptions sentryOptions) {
        return PropagationTargetsUtils.contain(sentryOptions.getTracePropagationTargets(), requestUrl);
    }

    public static final class TracingHeaders {
        @NotNull
        private final SentryTraceHeader sentryTraceHeader;
        @Nullable
        private final BaggageHeader baggageHeader;

        public TracingHeaders(@NotNull SentryTraceHeader sentryTraceHeader, @Nullable BaggageHeader baggageHeader) {
            this.sentryTraceHeader = sentryTraceHeader;
            this.baggageHeader = baggageHeader;
        }

        @NotNull
        public SentryTraceHeader getSentryTraceHeader() {
            return this.sentryTraceHeader;
        }

        @Nullable
        public BaggageHeader getBaggageHeader() {
            return this.baggageHeader;
        }
    }

    private static final class PropagationContextHolder {
        @Nullable
        private PropagationContext propagationContext = null;

        private PropagationContextHolder() {
        }
    }
}

