/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.general;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.util.ArrayList;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.tasks.EditTaskMenu;
import me.playbosswar.com.gui.tasks.general.ExecutionLimitMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class GeneralLimitsMenu
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;

    public GeneralLimitsMenu(Task task) {
        this.task = task;
        this.INVENTORY = SmartInventory.builder().id("task-limits").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.TASK_LIMIT_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        ArrayList<String> executionLimitLore = this.languageManager.getList(LanguageKey.EXECUTION_LIMIT_LORE, String.valueOf(this.task.getExecutionLimit()), String.valueOf(this.task.getTimesExecuted()), String.valueOf(this.task.isResetExecutionsAfterRestart()));
        executionLimitLore.add("");
        executionLimitLore.add(this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT));
        executionLimitLore.add(this.languageManager.get(LanguageKey.RIGHT_CLICK_RESET_EXECUTIONS));
        ItemStack executionLimitItem = Items.generateItem(LanguageKey.EXECUTION_LIMIT_TITLE, XMaterial.DIAMOND_AXE, executionLimitLore.toArray(new String[0]));
        ClickableItem clickableExecutionLimitItem = ClickableItem.of(executionLimitItem, e -> {
            if (e.isLeftClick()) {
                new ExecutionLimitMenu(player, this.task);
                return;
            }
            if (e.isRightClick()) {
                this.task.setTimesExecuted(0);
                this.task.storeInstance();
                CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this.task);
                this.INVENTORY.open(player);
            }
        });
        contents.set(1, 1, clickableExecutionLimitItem);
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new EditTaskMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

