/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.scheduler;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.time.LocalTime;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.tasks.general.ClickableTextInputButton;
import me.playbosswar.com.gui.tasks.scheduler.EditSpecificTimeMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;

public class EditHourMenu
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;
    private final TaskTime taskTime;
    private final boolean isTime2;
    private final String[] clockLore = new String[]{"", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT)};

    public EditHourMenu(Task task, TaskTime taskTime, boolean isTime2) {
        this.task = task;
        this.taskTime = taskTime;
        this.isTime2 = isTime2;
        this.INVENTORY = SmartInventory.builder().id("edit-hour").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.EDIT_HOURS_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        LocalTime usedTime;
        contents.fill(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        LocalTime localTime = usedTime = this.isTime2 ? this.taskTime.getTime2() : this.taskTime.getTime1();
        if (usedTime == null) {
            if (this.isTime2) {
                this.taskTime.setTime2(LocalTime.of(14, 0, 0));
                usedTime = this.taskTime.getTime2();
            } else {
                this.taskTime.setTime1(LocalTime.of(14, 0, 0));
                usedTime = this.taskTime.getTime1();
            }
            this.task.storeInstance();
            CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(this.task);
        }
        LocalTime finalUsedTime = usedTime;
        contents.set(0, 2, ClickableItem.of(Items.getAddItem(), e -> {
            this.setTime(this.task, finalUsedTime.plusHours(1L));
            this.refresh(player);
        }));
        ClickableTextInputButton hoursClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.HOURS_LABEL, String.valueOf(usedTime.getHour())), XMaterial.CLOCK, this.clockLore), LanguageKey.TEXT_INPUT_DEFAULT, data -> {
            int hours = Integer.parseInt(data);
            this.setTime(this.task, finalUsedTime.withHour(hours));
            this.refresh(player);
        });
        contents.set(1, 2, hoursClock.getItem());
        contents.set(2, 2, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.setTime(this.task, finalUsedTime.minusHours(1L));
            this.refresh(player);
        }));
        contents.set(0, 4, ClickableItem.of(Items.getAddItem(), e -> {
            this.setTime(this.task, finalUsedTime.plusMinutes(1L));
            this.refresh(player);
        }));
        ClickableTextInputButton minutesClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.MINUTES_LABEL, String.valueOf(usedTime.getMinute())), XMaterial.CLOCK, this.clockLore), LanguageKey.TEXT_INPUT_DEFAULT, data -> {
            int minutes = Integer.parseInt(data);
            this.setTime(this.task, finalUsedTime.withMinute(minutes));
            this.refresh(player);
        });
        contents.set(1, 4, minutesClock.getItem());
        contents.set(2, 4, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.setTime(this.task, finalUsedTime.minusMinutes(1L));
            this.refresh(player);
        }));
        contents.set(0, 6, ClickableItem.of(Items.getAddItem(), e -> {
            this.setTime(this.task, finalUsedTime.plusSeconds(1L));
            this.refresh(player);
        }));
        ClickableTextInputButton secondsClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.SECONDS_LABEL, String.valueOf(usedTime.getSecond())), XMaterial.CLOCK, this.clockLore), LanguageKey.TEXT_INPUT_DEFAULT, data -> {
            int seconds = Integer.parseInt(data);
            this.setTime(this.task, finalUsedTime.withSecond(seconds));
            this.refresh(player);
        });
        contents.set(1, 6, secondsClock.getItem());
        contents.set(2, 6, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.setTime(this.task, finalUsedTime.minusSeconds(1L));
            this.refresh(player);
        }));
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new EditSpecificTimeMenu((Task)this.task, (TaskTime)this.taskTime).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private void refresh(Player player) {
        this.INVENTORY.open(player);
    }

    private void setTime(Task task, LocalTime time) {
        if (this.isTime2) {
            this.taskTime.setTime2(time);
        } else {
            this.taskTime.setTime1(time);
        }
        task.storeInstance();
        CommandTimerPlugin.getInstance().getTasksManager().resetScheduleForTask(task);
    }
}

