/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.scheduler;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.time.LocalTime;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.tasks.scheduler.EditSpecificTimeMenu;
import me.playbosswar.com.gui.tasks.scheduler.MainScheduleMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class EditTimesMenu
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;

    public EditTimesMenu(Task task) {
        this.task = task;
        this.INVENTORY = SmartInventory.builder().id("task-times").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.TASK_TIMES_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getAllTimes(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        String[] addItemLore = this.languageManager.getList(LanguageKey.ADD_SPECIFIC_TIME_LORE).toArray(new String[0]);
        ItemStack addItem = Items.generateItem(LanguageKey.ADD_SPECIFIC_TIME_TITLE, XMaterial.ANVIL, addItemLore);
        ClickableItem clickableAddItem = ClickableItem.of(addItem, e -> {
            TaskTime taskTime = new TaskTime(LocalTime.parse("14:00:00"), false);
            this.task.addTime(taskTime);
            new EditSpecificTimeMenu((Task)this.task, (TaskTime)taskTime).INVENTORY.open(player);
        });
        contents.set(0, 0, clickableAddItem);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> new MainScheduleMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    private ClickableItem[] getAllTimes(Player p) {
        List<TaskTime> taskTimes = this.task.getTimes();
        ClickableItem[] items = new ClickableItem[taskTimes.size()];
        for (int i = 0; i < items.length; ++i) {
            TaskTime taskTime = taskTimes.get(i);
            String[] lore = new String[]{"", this.languageManager.get(LanguageKey.MINECRAFT_TIME_TITLE) + ": " + (taskTime.isMinecraftTime() ? this.languageManager.get(LanguageKey.YES_LABEL) : this.languageManager.get(LanguageKey.NO_LABEL)), "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT), this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE)};
            ItemStack item = Items.generateItem("\u00a7b" + taskTime, XMaterial.CLOCK, lore);
            items[i] = ClickableItem.of(item, e -> {
                if (e.getClick().equals((Object)ClickType.LEFT)) {
                    new EditSpecificTimeMenu((Task)this.task, (TaskTime)taskTime).INVENTORY.open(p);
                    return;
                }
                if (e.getClick().equals((Object)ClickType.RIGHT)) {
                    this.task.removeTime(taskTime);
                    this.INVENTORY.open(p);
                }
            });
        }
        return items;
    }
}

