/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.worlds;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WorldSelector
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final List<String> selectedWorlds;
    private final Callback<List<String>> callback;
    private final boolean allowMulti;

    public WorldSelector(Callback<List<String>> callback, List<String> selectedWorlds, boolean allowMulti) {
        this.callback = callback;
        this.selectedWorlds = selectedWorlds;
        this.allowMulti = allowMulti;
        LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
        this.INVENTORY = SmartInventory.builder().id("select-task-world").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(languageManager.get(LanguageKey.SELECT_WORLD_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getWorlds(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> this.callback.execute(this.selectedWorlds)));
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }

    private ClickableItem[] getWorlds(Player player) {
        List worlds = Bukkit.getWorlds();
        ClickableItem[] items = new ClickableItem[worlds.size()];
        for (int i = 0; i < items.length; ++i) {
            World world = (World)worlds.get(i);
            ItemStack item = Items.getToggleItem("\u00a7b" + world.getName(), new String[0], this.selectedWorlds.contains(world.getName()));
            items[i] = ClickableItem.of(item, e -> {
                if (!this.allowMulti) {
                    this.selectedWorlds.clear();
                }
                if (this.selectedWorlds.contains(world.getName())) {
                    this.selectedWorlds.remove(world.getName());
                } else {
                    this.selectedWorlds.add(world.getName());
                }
                new WorldSelector(this.callback, this.selectedWorlds, (boolean)this.allowMulti).INVENTORY.open(player);
            });
        }
        return items;
    }
}

