/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.hooks;

import java.util.Date;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.hooks.PlaceholderConfiguration;
import me.playbosswar.com.tasks.ScheduledTask;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.Tools;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Duration;
import org.joda.time.Interval;

public class PAPIPlaceholders
extends PlaceholderExpansion {
    private final Plugin plugin;

    public PAPIPlaceholders(Plugin p) {
        this.plugin = p;
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    @NotNull
    public String getIdentifier() {
        return "commandtimer";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        PlaceholderConfiguration placeholder = new PlaceholderConfiguration(identifier);
        if (!placeholder.isValid()) {
            Messages.sendConsole("Used a CommandTimer placeholder wrong. Example: %commandtimer_testtask_nextExecutionFormat%");
            return "INVALID PLACEHOLDER";
        }
        Task task = CommandTimerPlugin.getInstance().getTasksManager().getTaskByName(placeholder.getTaskName());
        String fallbackMessage = placeholder.getFallbackMessage();
        if (placeholder.getTaskName().equals("ALLTASKS")) {
            ScheduledTask scheduledTask = CommandTimerPlugin.getInstance().getTasksManager().getNextScheduledTaskForTask(task);
            if (scheduledTask == null) {
                return fallbackMessage;
            }
            task = scheduledTask.getTask();
        }
        if (task == null) {
            if (CommandTimerPlugin.getInstance().getConfig().getBoolean("disablePapiPlaceholderWarnings")) {
                return fallbackMessage;
            }
            Messages.sendConsole("Tried to use PAPI placeholder for unknown task:" + placeholder.getTaskName());
            return fallbackMessage;
        }
        if (placeholder.getPlaceholderType().equals("nextTaskName")) {
            return task.getName();
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("seconds")) {
            return this.getSecondsText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("secondsFormat")) {
            return this.getSecondsText(task, fallbackMessage, true);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("nextExecution")) {
            return this.getNextExecutionText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("nextExecutionFormat")) {
            return this.getNextExecutionText(task, fallbackMessage, true);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("lastExecution")) {
            return this.getLastExecutionText(task, fallbackMessage, false);
        }
        if (placeholder.getPlaceholderType().equalsIgnoreCase("lastExecutionFormat")) {
            return this.getLastExecutionText(task, fallbackMessage, true);
        }
        return this.getNextExecutionText(task, fallbackMessage, true, placeholder.getPlaceholderType());
    }

    private String getSecondsText(Task task, String fallbackMessage, boolean format) {
        int seconds = task.getInterval().toSeconds();
        if (seconds < 0 && fallbackMessage != null) {
            return fallbackMessage;
        }
        if (format) {
            return Tools.getTimeString(seconds);
        }
        return seconds + "";
    }

    private long getNextExecution(Task task) {
        ScheduledTask taskScheduled = CommandTimerPlugin.getInstance().getTasksManager().getNextScheduledTaskForTask(task);
        if (taskScheduled == null) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        return (taskScheduled.getDate().toInstant().toEpochMilli() - now) / 1000L;
    }

    private long getLastExecution(Task task) {
        if (task.getLastExecuted() == null || !task.isActive()) {
            return -1L;
        }
        long now = new Date().getTime();
        Interval interval = new Interval(task.getLastExecuted().getTime(), now);
        Duration period = interval.toDuration();
        return period.getStandardSeconds();
    }

    private String getNextExecutionText(Task task, String fallbackMessage, boolean format, String timeFormat) {
        long seconds = this.getNextExecution(task);
        if (seconds == -1L) {
            return fallbackMessage != null ? fallbackMessage : "";
        }
        if (format) {
            if (timeFormat == null) {
                timeFormat = seconds > 86400L ? "DD:HH:mm:ss" : "HH:mm:ss";
            }
            return Tools.getTimeString((int)seconds, timeFormat);
        }
        return seconds + "";
    }

    private String getLastExecutionText(Task task, String fallbackMessage, boolean format, String timeFormat) {
        long seconds = this.getLastExecution(task);
        if (seconds == -1L) {
            return fallbackMessage != null ? fallbackMessage : "";
        }
        if (format) {
            if (timeFormat == null) {
                timeFormat = seconds > 86400L ? "DD:HH:mm:ss" : "HH:mm:ss";
            }
            return Tools.getTimeString((int)seconds, timeFormat);
        }
        return seconds + "";
    }

    private String getNextExecutionText(Task task, String fallbackMessage, boolean format) {
        return this.getNextExecutionText(task, fallbackMessage, format, null);
    }

    private String getLastExecutionText(Task task, String fallbackMessage, boolean format) {
        return this.getLastExecutionText(task, fallbackMessage, format, null);
    }
}

