/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Random;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.tasks.PopulateScheduleRunner;
import me.playbosswar.com.tasks.ScheduledTask;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskRunner;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.tasks.TaskValidationHelpers;
import me.playbosswar.com.utils.CommandExecutor;
import me.playbosswar.com.utils.DatabaseUtils;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.Tools;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class TasksManager {
    private static final Random RANDOM = new Random();
    private static final String ALPHA_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private List<Task> loadedTasks = new ArrayList<Task>();
    private Queue<ScheduledTask> scheduledTasks = new PriorityQueue<ScheduledTask>(Comparator.comparing(ScheduledTask::getDate));
    private Thread runnerThread;
    private Thread populateScheduleRunnerThread;
    public boolean stopRunner = false;
    public int executionsSinceLastSync = 0;

    public TasksManager(Plugin plugin) {
        if (plugin.getConfig().getBoolean("database.enabled")) {
            try {
                Messages.sendConsole("Loading all tasks from database");
                List<Task> tasks = DatabaseUtils.getAllTasksFromDatabase();
                this.loadedTasks.addAll(tasks);
                Messages.sendConsole("Loaded " + this.loadedTasks.size() + " tasks from database");
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else {
            this.loadedTasks.addAll(me.playbosswar.com.utils.Files.deserializeJsonFilesIntoCommandTimers());
        }
        this.loadedTasks.forEach(task -> {
            if (task.isResetExecutionsAfterRestart()) {
                task.setTimesExecuted(0);
                task.setLastExecuted(new Date());
            }
        });
        this.startPopulateScheduleRunner();
        this.startRunner();
    }

    public Task createTask() {
        String name = "Task_" + TasksManager.generateRandomAlphabetic(4);
        Task task = new Task(name);
        this.loadedTasks.add(task);
        return task;
    }

    private static String generateRandomAlphabetic(int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHA_CHARS.charAt(RANDOM.nextInt(ALPHA_CHARS.length())));
        }
        return sb.toString();
    }

    @Nullable
    public Task getTaskByName(String name) {
        Optional<Task> optionalTask = this.loadedTasks.stream().filter(task -> task.getName().equalsIgnoreCase(name)).findFirst();
        return optionalTask.orElse(null);
    }

    public void removeTask(Task task) throws IOException {
        this.resetScheduleForTask(task);
        if (CommandTimerPlugin.getPlugin().getConfig().getBoolean("database.enabled")) {
            try {
                CommandTimerPlugin.getTaskDao().delete(task);
                Files.delete(Paths.get(me.playbosswar.com.utils.Files.getTaskLocalExecutionFile(task.getId()), new String[0]));
                this.loadedTasks.remove(task);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.loadedTasks.remove(task);
                Files.delete(Paths.get(me.playbosswar.com.utils.Files.getTaskFile(task.getId()), new String[0]));
                Files.delete(Paths.get(me.playbosswar.com.utils.Files.getTaskLocalExecutionFile(task.getId()), new String[0]));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<Task> getLoadedTasks() {
        return this.loadedTasks;
    }

    public List<Task> getActiveTasks() {
        return this.loadedTasks.stream().filter(Task::isActive).collect(Collectors.toList());
    }

    public void setLoadedTasks(List<Task> loadedTasks) {
        this.loadedTasks = loadedTasks;
    }

    private void startRunner() {
        TaskRunner runner = new TaskRunner(this);
        Thread thread = new Thread(runner);
        thread.start();
        this.runnerThread = thread;
    }

    private void startPopulateScheduleRunner() {
        PopulateScheduleRunner runner = new PopulateScheduleRunner(this);
        Thread thread = new Thread(runner);
        thread.start();
        this.populateScheduleRunnerThread = thread;
    }

    public void processCommandExecution(Task task, TaskCommand taskCommand) {
        if (!task.isActive()) {
            return;
        }
        CommandTimerPlugin.getScheduler().runTaskAsynchronously(() -> {
            boolean executed;
            CommandExecutor.ExecutionContext.Builder builder = new CommandExecutor.ExecutionContext.Builder().command(taskCommand.getCommand()).gender(taskCommand.getGender()).interval(taskCommand.getInterval()).executionCounter(count -> ++this.executionsSinceLastSync);
            if (task.hasCondition()) {
                builder.conditionChecker(p -> TaskValidationHelpers.processCondition(task.getCondition(), p));
            }
            if (executed = CommandExecutor.execute(builder.build())) {
                task.setLastExecuted(new Date());
                task.setTimesExecuted(task.getTimesExecuted() + 1);
            }
        });
    }

    public Queue<ScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    public void resetScheduleForTask(Task task) {
        this.scheduledTasks.removeIf(scheduledTask -> scheduledTask.getTask().getId().equals(task.getId()));
    }

    public void populateScheduleForTask(Task task) {
        Object latestScheduledDate;
        Messages.sendDebugConsole("Populating schedule for task: " + task.getName());
        if (!task.isActive()) {
            Messages.sendDebugConsole("Task " + task.getName() + " is not active, skipping scheduling");
            return;
        }
        boolean usesMinecraftTime = task.getTimes().stream().anyMatch(TaskTime::isMinecraftTime);
        if (usesMinecraftTime) {
            this.scheduledTasks.removeIf(st -> st.getTask().getId().equals(task.getId()));
        }
        int executionLimit = task.getExecutionLimit();
        int timesExecuted = task.getTimesExecuted();
        long alreadyScheduled = this.scheduledTasks.stream().filter(scheduledTask -> scheduledTask.getTask().getId().equals(task.getId())).count();
        if (alreadyScheduled >= 50L) {
            Messages.sendDebugConsole("Task " + task.getName() + " has already been scheduled 50 times, skipping scheduling");
            return;
        }
        int maxToSchedule = 50;
        if (executionLimit != -1) {
            int remaining = executionLimit - timesExecuted - (int)alreadyScheduled;
            if (remaining <= 0) {
                Messages.sendDebugConsole("Task " + task.getName() + " has reached execution limit, skipping scheduling");
                return;
            }
            maxToSchedule = Math.min(maxToSchedule, remaining);
        }
        if ((latestScheduledDate = (ZonedDateTime)this.scheduledTasks.stream().filter(scheduledTask -> scheduledTask.getTask().getId().equals(task.getId())).map(ScheduledTask::getDate).max(ChronoZonedDateTime::compareTo).orElse(null)) == null) {
            ZonedDateTime now = ZonedDateTime.now();
            ZonedDateTime lastExecuted = task.getLastExecuted().toInstant().atZone(ZoneId.systemDefault());
            Object object = latestScheduledDate = lastExecuted.isAfter(now) ? lastExecuted : now;
        }
        if (maxToSchedule <= 0) {
            return;
        }
        if (!task.getTimes().isEmpty()) {
            for (TaskTime taskTime : task.getTimes()) {
                if (taskTime.isMinecraftTime()) {
                    World world = Bukkit.getWorld((String)(taskTime.getWorld() == null ? "world" : taskTime.getWorld()));
                    if (world == null) continue;
                    if (taskTime.isRange()) {
                        LocalTime startRange = taskTime.getTime1();
                        LocalTime endRange = taskTime.getTime2();
                        LocalTime currentMcTime = Tools.getMinecraftTimeAt(world, ZonedDateTime.now());
                        boolean currentlyInWindow = this.isTimeInRange(currentMcTime, startRange, endRange);
                        int mcDay = 0;
                        boolean firstIteration = true;
                        while (maxToSchedule > 0) {
                            ZonedDateTime windowEnd;
                            ZonedDateTime windowStart;
                            if (firstIteration && currentlyInWindow) {
                                windowStart = ZonedDateTime.now();
                                windowEnd = Tools.getNextMinecraftTime(world, endRange, 0);
                                if (windowEnd.isBefore(windowStart)) {
                                    windowEnd = Tools.getNextMinecraftTime(world, endRange, 1);
                                }
                            } else {
                                int dayOffset;
                                int n = dayOffset = firstIteration && currentlyInWindow ? 1 : mcDay;
                                if (firstIteration && !currentlyInWindow) {
                                    dayOffset = 0;
                                }
                                windowStart = Tools.getNextMinecraftTime(world, startRange, dayOffset);
                                windowEnd = Tools.getNextMinecraftTime(world, endRange, dayOffset);
                                if (windowEnd.isBefore(windowStart)) {
                                    windowEnd = Tools.getNextMinecraftTime(world, endRange, dayOffset + 1);
                                }
                            }
                            firstIteration = false;
                            if (!task.getDays().contains(windowStart.toLocalDate().getDayOfWeek())) {
                                ++mcDay;
                                continue;
                            }
                            if (windowEnd.isBefore((ChronoZonedDateTime<?>)latestScheduledDate)) {
                                ++mcDay;
                                continue;
                            }
                            Object execTime = windowStart.isBefore((ChronoZonedDateTime<?>)latestScheduledDate) ? latestScheduledDate : windowStart;
                            long intervalSeconds = task.getInterval().toSeconds();
                            if (intervalSeconds <= 0L) {
                                intervalSeconds = 1L;
                            }
                            while (maxToSchedule > 0 && !execTime.isAfter(windowEnd)) {
                                if (!execTime.isBefore((ChronoZonedDateTime<?>)latestScheduledDate)) {
                                    this.scheduledTasks.add(new ScheduledTask(task, (ZonedDateTime)execTime));
                                    --maxToSchedule;
                                }
                                execTime = ((ZonedDateTime)execTime).plusSeconds(intervalSeconds);
                            }
                            ++mcDay;
                        }
                        continue;
                    }
                    LocalTime time = taskTime.getTime1();
                    int i = 0;
                    while (maxToSchedule > 0) {
                        ZonedDateTime nextMinecraftTime = Tools.getNextMinecraftTime(world, time, i);
                        if (!task.getDays().contains(nextMinecraftTime.getDayOfWeek())) {
                            ++i;
                            continue;
                        }
                        if (nextMinecraftTime.isBefore((ChronoZonedDateTime<?>)latestScheduledDate)) {
                            ++i;
                            continue;
                        }
                        this.scheduledTasks.add(new ScheduledTask(task, nextMinecraftTime));
                        --maxToSchedule;
                        ++i;
                    }
                    continue;
                }
                if (taskTime.isRange()) {
                    LocalTime startRange = taskTime.getTime1();
                    LocalTime endRange = taskTime.getTime2();
                    int i = 0;
                    while (maxToSchedule > 0) {
                        ZonedDateTime date = ZonedDateTime.of(LocalDate.now(), startRange, ZoneId.systemDefault()).plusSeconds(i * task.getInterval().toSeconds());
                        if (!task.getDays().contains(date.getDayOfWeek())) {
                            ++i;
                            continue;
                        }
                        if (!date.toLocalTime().isAfter(startRange) || !date.toLocalTime().isBefore(endRange)) {
                            ++i;
                            continue;
                        }
                        if (date.isBefore((ChronoZonedDateTime<?>)latestScheduledDate)) {
                            ++i;
                            continue;
                        }
                        this.scheduledTasks.add(new ScheduledTask(task, date));
                        --maxToSchedule;
                        ++i;
                    }
                    continue;
                }
                LocalTime time = taskTime.getTime1();
                int i = 0;
                while (maxToSchedule > 0) {
                    ZonedDateTime date = ZonedDateTime.of(LocalDate.now(), time, ZoneId.systemDefault()).plusDays(i);
                    if (!task.getDays().contains(date.getDayOfWeek())) {
                        ++i;
                        continue;
                    }
                    if (date.isBefore((ChronoZonedDateTime<?>)latestScheduledDate)) {
                        ++i;
                        continue;
                    }
                    this.scheduledTasks.add(new ScheduledTask(task, date));
                    --maxToSchedule;
                    ++i;
                }
            }
            return;
        }
        if (task.getInterval().toSeconds() == 0 && !task.getEvents().isEmpty()) {
            Messages.sendDebugConsole("Task " + task.getName() + "has no interval set and uses events, skipping scheduling");
            return;
        }
        int i = 0;
        while (maxToSchedule > 0) {
            ZonedDateTime date = ((ZonedDateTime)latestScheduledDate).plusSeconds(i * task.getInterval().toSeconds());
            if (!task.getDays().contains(date.getDayOfWeek())) {
                ++i;
                continue;
            }
            this.scheduledTasks.add(new ScheduledTask(task, date));
            --maxToSchedule;
            ++i;
        }
    }

    public ScheduledTask getNextScheduledTaskForTask(Task task) {
        return this.scheduledTasks.stream().filter(scheduledTask -> scheduledTask.getTask().getId().equals(task.getId())).min(Comparator.comparing(ScheduledTask::getDate)).orElse(null);
    }

    public int getNextTaskCommandIndex(Task task) {
        int selectedCommandIndex = -1;
        if (task.getCommandExecutionMode().equals((Object)CommandExecutionMode.RANDOM)) {
            selectedCommandIndex = Tools.getRandomInt(0, task.getCommands().size() - 1);
        } else if (task.getCommandExecutionMode().equals((Object)CommandExecutionMode.ORDERED)) {
            int currentLatestCommandIndex = task.getLastExecutedCommandIndex();
            selectedCommandIndex = currentLatestCommandIndex >= task.getCommands().size() - 1 ? 0 : currentLatestCommandIndex + 1;
        }
        return selectedCommandIndex;
    }

    private boolean isTimeInRange(LocalTime time, LocalTime start, LocalTime end) {
        if (start.isBefore(end)) {
            return !time.isBefore(start) && !time.isAfter(end);
        }
        return !time.isBefore(start) || !time.isAfter(end);
    }

    public void disable() {
        this.stopRunner = true;
        if (this.runnerThread != null && this.runnerThread.isAlive()) {
            this.runnerThread.interrupt();
        }
        if (this.populateScheduleRunnerThread != null && this.populateScheduleRunnerThread.isAlive()) {
            this.populateScheduleRunnerThread.interrupt();
        }
    }
}

