/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.Gender;
import me.playbosswar.com.hooks.PAPIHook;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.StringEnhancer;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandExecutor {
    private static final String CONDITION_NO_MATCH = "Conditions did not match";

    public static boolean execute(ExecutionContext context) {
        Gender gender = context.gender;
        if (gender.equals((Object)Gender.CONSOLE)) {
            return CommandExecutor.runConsoleCommand(context);
        }
        if (gender.equals((Object)Gender.PLAYER)) {
            return CommandExecutor.runPlayerCommand(context);
        }
        if (gender.equals((Object)Gender.OPERATOR)) {
            return CommandExecutor.runOperatorCommand(context);
        }
        if (gender.equals((Object)Gender.CONSOLE_PER_USER)) {
            return CommandExecutor.runConsolePerUserCommand(context);
        }
        if (gender.equals((Object)Gender.CONSOLE_PER_USER_OFFLINE)) {
            return CommandExecutor.runConsolePerUserOfflineCommand(context);
        }
        if (gender.equals((Object)Gender.CONSOLE_PROXY)) {
            return CommandExecutor.runConsoleProxyCommand(context);
        }
        return false;
    }

    private static boolean runConsoleCommand(ExecutionContext context) {
        Boolean valid;
        if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(null)) != null && valid.booleanValue())) {
            Messages.sendDebugConsole(CONDITION_NO_MATCH);
            return false;
        }
        String command = context.command;
        CommandTimerPlugin.getScheduler().runTask(() -> {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, null));
            if (context.executionCounter != null) {
                context.executionCounter.accept(1);
            }
        });
        if (context.onExecution != null) {
            context.onExecution.run();
        }
        return true;
    }

    private static boolean runPlayerCommand(ExecutionContext context) {
        String command = context.command;
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (context.scopedPlayers != null && !context.scopedPlayers.isEmpty()) {
            affectedPlayers = context.scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecution = context.interval.toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            Boolean valid;
            if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(p)) != null && valid.booleanValue())) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            willExecute = true;
            if (delayedExecution) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> CommandExecutor.runForPlayer(p, command, context), 20L * (long)i * (long)context.interval.toSeconds() + 1L);
            } else {
                CommandExecutor.runForPlayer(p, command, context);
            }
            ++i;
        }
        return willExecute;
    }

    private static void runForPlayer(Player p, String command, ExecutionContext context) {
        String parsedCommand = PAPIHook.parsePAPI(command, (OfflinePlayer)p);
        CommandTimerPlugin.getScheduler().runTask(() -> {
            boolean executed = p.performCommand(parsedCommand);
            if (!executed) {
                String errorMessage = new StringEnhancer("Failed to execute command {command}").add("command", command).parse();
                throw new CommandException(errorMessage);
            }
            if (context.executionCounter != null) {
                context.executionCounter.accept(1);
            }
            if (context.onExecution != null) {
                context.onExecution.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runOperatorCommand(ExecutionContext context) {
        String command = context.command;
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (context.scopedPlayers != null && !context.scopedPlayers.isEmpty()) {
            affectedPlayers = context.scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecutions = context.interval.toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            boolean wasAlreadyOp = p.isOp();
            try {
                Boolean valid;
                p.setOp(true);
                if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(p)) != null && valid.booleanValue())) {
                    Messages.sendDebugConsole(CONDITION_NO_MATCH);
                    if (wasAlreadyOp) continue;
                    p.setOp(false);
                    continue;
                }
                willExecute = true;
                if (delayedExecutions) {
                    CommandTimerPlugin.getScheduler().runTaskLater(() -> {
                        p.performCommand(PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                        if (context.executionCounter != null) {
                            context.executionCounter.accept(1);
                        }
                        if (context.onExecution != null) {
                            context.onExecution.run();
                        }
                    }, 20L * (long)i * (long)context.interval.toSeconds() + 1L);
                } else {
                    CommandTimerPlugin.getScheduler().runTask(() -> {
                        p.performCommand(PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                        if (context.executionCounter != null) {
                            context.executionCounter.accept(1);
                        }
                        if (context.onExecution != null) {
                            context.onExecution.run();
                        }
                    });
                }
            }
            finally {
                if (wasAlreadyOp) continue;
                p.setOp(false);
                continue;
            }
            ++i;
        }
        return willExecute;
    }

    private static boolean runConsolePerUserCommand(ExecutionContext context) {
        String command = context.command;
        Collection affectedPlayers = Bukkit.getOnlinePlayers();
        if (context.scopedPlayers != null && !context.scopedPlayers.isEmpty()) {
            affectedPlayers = context.scopedPlayers.stream().map(Bukkit::getPlayer).filter(Objects::nonNull).collect(Collectors.toList());
        }
        boolean delayedExecutions = context.interval.toSeconds() > 0;
        int i = 0;
        boolean willExecute = false;
        for (Player p : affectedPlayers) {
            Boolean valid;
            if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(p)) != null && valid.booleanValue())) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            willExecute = true;
            if (delayedExecutions) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                    if (context.executionCounter != null) {
                        context.executionCounter.accept(1);
                    }
                    if (context.onExecution != null) {
                        context.onExecution.run();
                    }
                }, 20L * (long)i * (long)context.interval.toSeconds() + 1L);
            } else {
                CommandTimerPlugin.getScheduler().runTask(() -> {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, (OfflinePlayer)p));
                    if (context.executionCounter != null) {
                        context.executionCounter.accept(1);
                    }
                    if (context.onExecution != null) {
                        context.onExecution.run();
                    }
                });
            }
            ++i;
        }
        return willExecute;
    }

    private static boolean runConsolePerUserOfflineCommand(ExecutionContext context) {
        String command = context.command;
        boolean delayedExecutions = context.interval.toSeconds() > 0;
        int i = 0;
        for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
            Boolean valid;
            if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(p)) != null && valid.booleanValue())) {
                Messages.sendDebugConsole(CONDITION_NO_MATCH);
                continue;
            }
            if (delayedExecutions) {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> CommandTimerPlugin.getScheduler().runTask(() -> {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, p));
                    if (context.executionCounter != null) {
                        context.executionCounter.accept(1);
                    }
                    if (context.onExecution != null) {
                        context.onExecution.run();
                    }
                }), 20L * (long)i * (long)context.interval.toSeconds() + 1L);
            } else {
                CommandTimerPlugin.getScheduler().runTask(() -> {
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), PAPIHook.parsePAPI(command, p));
                    if (context.executionCounter != null) {
                        context.executionCounter.accept(1);
                    }
                    if (context.onExecution != null) {
                        context.onExecution.run();
                    }
                });
            }
            ++i;
        }
        return true;
    }

    private static boolean runConsoleProxyCommand(ExecutionContext context) {
        Boolean valid;
        if (!(context.conditionChecker == null || (valid = (Boolean)context.conditionChecker.apply(null)) != null && valid.booleanValue())) {
            Messages.sendDebugConsole(CONDITION_NO_MATCH);
            return false;
        }
        String command = context.command;
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            out.writeUTF("executeConsoleCommand");
            out.writeUTF(command);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getServer().sendPluginMessage(CommandTimerPlugin.getPlugin(), "commandtimer:main", b.toByteArray());
        if (context.executionCounter != null) {
            context.executionCounter.accept(1);
        }
        if (context.onExecution != null) {
            context.onExecution.run();
        }
        return true;
    }

    public static class ExecutionContext {
        private final String command;
        private final Gender gender;
        private final TaskInterval interval;
        private final List<UUID> scopedPlayers;
        private final Function<OfflinePlayer, Boolean> conditionChecker;
        private final Runnable onExecution;
        private final Consumer<Integer> executionCounter;

        private ExecutionContext(Builder builder) {
            this.command = builder.command;
            this.gender = builder.gender;
            this.interval = builder.interval != null ? builder.interval : new TaskInterval(0, 0, 0, 0);
            this.scopedPlayers = builder.scopedPlayers;
            this.conditionChecker = builder.conditionChecker;
            this.onExecution = builder.onExecution;
            this.executionCounter = builder.executionCounter;
        }

        public static class Builder {
            private String command;
            private Gender gender;
            private TaskInterval interval;
            private List<UUID> scopedPlayers;
            private Function<OfflinePlayer, Boolean> conditionChecker;
            private Runnable onExecution;
            private Consumer<Integer> executionCounter;

            public Builder command(String command) {
                this.command = command;
                return this;
            }

            public Builder gender(Gender gender) {
                this.gender = gender;
                return this;
            }

            public Builder interval(TaskInterval interval) {
                this.interval = interval;
                return this;
            }

            public Builder scopedPlayers(List<UUID> scopedPlayers) {
                this.scopedPlayers = scopedPlayers;
                return this;
            }

            public Builder conditionChecker(Function<OfflinePlayer, Boolean> conditionChecker) {
                this.conditionChecker = conditionChecker;
                return this;
            }

            public Builder onExecution(Runnable onExecution) {
                this.onExecution = onExecution;
                return this;
            }

            public Builder executionCounter(Consumer<Integer> executionCounter) {
                this.executionCounter = executionCounter;
                return this;
            }

            public ExecutionContext build() {
                return new ExecutionContext(this);
            }
        }
    }
}

