/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.events.EventConfiguration;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskExecutionMetadata;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.gson.GsonConverter;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Files {
    static String pluginFolderPath = CommandTimerPlugin.getPlugin().getDataFolder().getPath();

    public static void createDataFolders() {
        File timersFile = new File(pluginFolderPath + "/timers");
        File extensionsFolder = new File(pluginFolderPath + "/extensions");
        File adHocCommandsFolder = new File(pluginFolderPath + "/ad-hoc-commands");
        File executionDataFolder = new File(pluginFolderPath + "/execution-data");
        timersFile.mkdirs();
        extensionsFolder.mkdirs();
        adHocCommandsFolder.mkdirs();
        executionDataFolder.mkdirs();
        File dataFolder = CommandTimerPlugin.getPlugin().getDataFolder();
        File enLangFile = new File(dataFolder.getAbsoluteFile() + "/languages/en.json");
        if (!enLangFile.exists()) {
            Messages.sendDebugConsole("could not find languages/en.json, creating default");
            CommandTimerPlugin.getPlugin().saveResource("languages/en.json", false);
        }
        CommandTimerPlugin.getPlugin().saveResource("languages/default.json", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File findTaskFileByUuid(UUID id) {
        File dir = new File(pluginFolderPath + "/timers");
        File[] files = dir.listFiles(file -> file.getName().endsWith(".json"));
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            try (FileReader fr = new FileReader(file2);){
                UUID fileId;
                JsonObject json = new JsonParser().parse((Reader)fr).getAsJsonObject();
                if (json.has("id") && (fileId = UUID.fromString(json.get("id").getAsString())).equals(id)) {
                    File file3 = file2;
                    return file3;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File findMetadataFileByUuid(UUID id) {
        File dir = new File(pluginFolderPath + "/execution-data");
        File[] files = dir.listFiles(file -> file.getName().endsWith(".json"));
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            try (FileReader fr = new FileReader(file2);){
                UUID fileId;
                JsonObject json = new JsonParser().parse((Reader)fr).getAsJsonObject();
                if (json.has("taskId") && (fileId = UUID.fromString(json.get("taskId").getAsString())).equals(id)) {
                    File file3 = file2;
                    return file3;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File findAdHocCommandFileByUuid(UUID id) {
        File dir = new File(pluginFolderPath + "/ad-hoc-commands");
        File[] files = dir.listFiles(file -> file.getName().endsWith(".json"));
        if (files == null) {
            return null;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = fileArray[n2];
            try (FileReader fr = new FileReader(file2);){
                UUID fileId;
                JsonObject json = new JsonParser().parse((Reader)fr).getAsJsonObject();
                if (json.has("id") && (fileId = UUID.fromString(json.get("id").getAsString())).equals(id)) {
                    File file3 = file2;
                    return file3;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    public static String getTaskFile(UUID id) {
        File file = Files.findTaskFileByUuid(id);
        if (file != null) {
            return file.getAbsolutePath();
        }
        throw new IllegalStateException("Task file not found for UUID: " + id);
    }

    public static String getTaskLocalExecutionFile(UUID id) {
        File file = Files.findMetadataFileByUuid(id);
        if (file != null) {
            return file.getAbsolutePath();
        }
        throw new IllegalStateException("Task metadata file not found for UUID: " + id);
    }

    public static String getNewTaskFile(UUID id) {
        return pluginFolderPath + "/timers/" + id + ".json";
    }

    public static String getNewTaskLocalExecutionFile(UUID id) {
        return pluginFolderPath + "/execution-data/" + id + ".json";
    }

    public static String getAdHocCommandsDirectory() {
        return pluginFolderPath + "/ad-hoc-commands";
    }

    public static String getAdHocCommandFile(UUID id) {
        File file = Files.findAdHocCommandFileByUuid(id);
        if (file != null) {
            return file.getAbsolutePath();
        }
        throw new IllegalStateException("Ad-hoc command file not found for UUID: " + id);
    }

    public static String getNewAdHocCommandFile(UUID id) {
        return pluginFolderPath + "/ad-hoc-commands/" + id + ".json";
    }

    private static void healTask(Task task) {
        TaskInterval defaultInterval = new TaskInterval(0, 0, 0, 5);
        if (task.getCommands() == null) {
            task.setCommands(new ArrayList<TaskCommand>());
        }
        if (task.getInterval() == null) {
            task.setInterval(defaultInterval);
        }
        if (task.getTimes() == null) {
            task.setTimes(new ArrayList<TaskTime>());
        }
        if (task.getCommandExecutionInterval() == null) {
            task.setCommandExecutionInterval(defaultInterval);
        }
    }

    public static TaskExecutionMetadata getOrCreateTaskMetadata(Task task) {
        try {
            File file = Files.findMetadataFileByUuid(task.getId());
            if (file == null || !file.exists()) {
                TaskExecutionMetadata metadata = new TaskExecutionMetadata(task.getId(), task.getTimesExecuted(), task.getLastExecutedCommandIndex(), task.getLastExecuted());
                GsonConverter gson = new GsonConverter();
                String json = gson.toJson(metadata);
                String path = Files.getNewTaskLocalExecutionFile(task.getId());
                try (FileWriter jsonFile = new FileWriter(path);){
                    jsonFile.write(json);
                    jsonFile.flush();
                }
                return metadata;
            }
            FileReader fr = new FileReader(file);
            JSONParser jsonParser = new JSONParser();
            TaskExecutionMetadata metadata = (TaskExecutionMetadata)new GsonConverter().fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)TaskExecutionMetadata.class));
            return metadata;
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateLocalTaskMetadata(Task task) {
        TaskExecutionMetadata metadata = new TaskExecutionMetadata(task.getId(), task.getTimesExecuted(), task.getLastExecutedCommandIndex(), task.getLastExecuted());
        GsonConverter gson = new GsonConverter();
        String json = gson.toJson(metadata);
        File file = Files.findMetadataFileByUuid(task.getId());
        String path = file != null ? file.getAbsolutePath() : Files.getNewTaskLocalExecutionFile(task.getId());
        try (FileWriter jsonFile = new FileWriter(path);){
            jsonFile.write(json);
            jsonFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Task> deserializeJsonFilesIntoCommandTimers() {
        ITransaction transaction = Sentry.startTransaction("deserializeJsonFilesIntoCommandTimers()", "initiation");
        File dir = new File(pluginFolderPath + "/timers");
        File[] directoryListing = dir.listFiles(file -> file.getName().endsWith(".json"));
        JSONParser jsonParser = new JSONParser();
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            if (directoryListing != null) {
                for (File file2 : directoryListing) {
                    if (!file2.exists() || !file2.getName().contains(".json")) continue;
                    try {
                        TaskExecutionMetadata metadata;
                        Messages.sendConsole("Loading task " + file2.getName());
                        FileReader fr = new FileReader(file2.getPath());
                        GsonConverter gson = new GsonConverter();
                        Task task = (Task)gson.fromJson(jsonParser.parse((Reader)fr).toString(), (Type)((Object)Task.class));
                        Files.healTask(task);
                        task.getCommands().forEach(command -> {
                            if (command.getInterval() == null) {
                                command.setInterval(new TaskInterval(0, 0, 0, 0));
                            }
                            if (command.getDelay() == null) {
                                command.setDelay(new TaskInterval(0, 0, 0, 0));
                            }
                        });
                        if (task.getEvents() == null) {
                            task.setEvents(new ArrayList<EventConfiguration>());
                        }
                        if ((metadata = Files.getOrCreateTaskMetadata(task)) != null) {
                            task.setTimesExecuted(metadata.getTimesExecuted());
                            task.setLastExecutedCommandIndex(metadata.getLastExecutedCommandIndex());
                            task.setLastExecuted(metadata.getLastExecuted());
                        }
                        tasks.add(task);
                    }
                    catch (JsonParseException e) {
                        Bukkit.getLogger().log(Level.SEVERE, "Failed to process " + file2.getName() + " because of " + e.getMessage());
                    }
                    catch (ParseException e) {
                        Bukkit.getLogger().log(Level.SEVERE, "Failed to process " + file2.getName() + " because of " + e.getMessage());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            transaction.setThrowable(e);
        }
        finally {
            transaction.finish();
        }
        return tasks;
    }

    @Nullable
    public static <T> Class<? extends T> findClass(@NotNull File file, @NotNull Class<T> clazz) throws IOException, ClassNotFoundException {
        if (!file.exists()) {
            return null;
        }
        URL jar = file.toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{jar}, clazz.getClassLoader());
        ArrayList<String> matches = new ArrayList<String>();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        try (JarInputStream stream = new JarInputStream(jar.openStream());){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                matches.add(name.substring(0, name.lastIndexOf(46)).replace('/', '.'));
            }
            for (String match : matches) {
                try {
                    Class<?> loaded = loader.loadClass(match);
                    if (!clazz.isAssignableFrom(loaded)) continue;
                    classes.add(loaded.asSubclass(clazz));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        if (classes.isEmpty()) {
            loader.close();
            return null;
        }
        return (Class)classes.get(0);
    }
}

