/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.utils.Messages;
import org.bukkit.World;
import org.joda.time.Duration;

public class Tools {
    public static void printDate() {
        LocalDate date = LocalDate.now();
        DayOfWeek dow = date.getDayOfWeek();
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        Messages.sendConsole("&aServer time :&e " + time);
        Messages.sendConsole("&aServer day :&e " + dow);
    }

    public static boolean randomCheck(double random) {
        Random r = new Random();
        float chance = r.nextFloat();
        return (double)chance <= random;
    }

    public static int getRandomInt(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static String calculateWorldTime(World w) {
        if (w == null) {
            return "00:00";
        }
        long gameTime = w.getTime();
        long hours = gameTime / 1000L + 6L;
        long minutes = gameTime % 1000L * 60L / 1000L;
        if (hours == 0L) {
            hours = 12L;
        }
        if (hours >= 24L) {
            hours -= 24L;
        }
        String mm = "0" + minutes;
        mm = mm.substring(mm.length() - 2);
        String realHours = String.valueOf(hours);
        if (hours < 10L) {
            realHours = "0" + realHours;
        }
        return realHours + ":" + mm;
    }

    private static String getTimeStringLegacy(int seconds, String format) {
        LocalDateTime local = LocalDateTime.ofInstant(Instant.ofEpochSecond(seconds), ZoneId.of("GMT"));
        return local.format(DateTimeFormatter.ofPattern(format));
    }

    public static String getTimeString(int seconds, String format) {
        if (!format.contains("DD")) {
            return Tools.getTimeStringLegacy(seconds, format);
        }
        Duration duration = Duration.standardSeconds(seconds);
        int days = (int)duration.getStandardDays();
        int hours = (int)(duration.getStandardHours() % 24L);
        int minutes = (int)(duration.getStandardMinutes() % 60L);
        int remainingSeconds = (int)(duration.getStandardSeconds() % 60L);
        return format.replace("DD", String.format("%02d", days)).replace("HH", String.format("%02d", hours)).replace("mm", String.format("%02d", minutes)).replace("ss", String.format("%02d", remainingSeconds));
    }

    private static String getTenthNumeric(long val) {
        if (val < 9L) {
            return "0" + val;
        }
        return val + "";
    }

    public static String getTimeString(int seconds) {
        int day = (int)TimeUnit.SECONDS.toDays(seconds);
        long hours = TimeUnit.SECONDS.toHours(seconds) - (long)day * 24L;
        long minute = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
        long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
        if (day > 0) {
            return Tools.getTenthNumeric(day) + ":" + Tools.getTenthNumeric(hours) + ":" + Tools.getTenthNumeric(minute) + ":" + Tools.getTenthNumeric(second);
        }
        return Tools.getTenthNumeric(hours) + ":" + Tools.getTenthNumeric(minute) + ":" + Tools.getTenthNumeric(second);
    }

    public static TaskInterval parseTimeString(String timeString) {
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        String remaining = timeString.toLowerCase();
        if (remaining.contains("d")) {
            int dIndex;
            int dEnd;
            for (dEnd = dIndex = remaining.indexOf("d"); dEnd > 0 && Character.isDigit(remaining.charAt(dEnd - 1)); --dEnd) {
            }
            if (dEnd < dIndex) {
                days = Integer.parseInt(remaining.substring(dEnd, dIndex));
                remaining = remaining.substring(0, dEnd) + remaining.substring(dIndex + 1);
            }
        }
        if (remaining.contains("h")) {
            int hIndex;
            int hEnd;
            for (hEnd = hIndex = remaining.indexOf("h"); hEnd > 0 && Character.isDigit(remaining.charAt(hEnd - 1)); --hEnd) {
            }
            if (hEnd < hIndex) {
                hours = Integer.parseInt(remaining.substring(hEnd, hIndex));
                remaining = remaining.substring(0, hEnd) + remaining.substring(hIndex + 1);
            }
        }
        if (remaining.contains("m")) {
            int mIndex;
            int mEnd;
            for (mEnd = mIndex = remaining.indexOf("m"); mEnd > 0 && Character.isDigit(remaining.charAt(mEnd - 1)); --mEnd) {
            }
            if (mEnd < mIndex) {
                minutes = Integer.parseInt(remaining.substring(mEnd, mIndex));
                remaining = remaining.substring(0, mEnd) + remaining.substring(mIndex + 1);
            }
        }
        if (remaining.contains("s")) {
            int sIndex;
            int sEnd;
            for (sEnd = sIndex = remaining.indexOf("s"); sEnd > 0 && Character.isDigit(remaining.charAt(sEnd - 1)); --sEnd) {
            }
            if (sEnd < sIndex) {
                seconds = Integer.parseInt(remaining.substring(sEnd, sIndex));
            }
        }
        return new TaskInterval(days, hours, minutes, seconds);
    }

    public static ZonedDateTime getNextMinecraftTime(World world, LocalTime targetMcTime, int occurrence) {
        long currentTicks = world.getTime();
        long targetTicks = Tools.minecraftTimeToTicks(targetMcTime);
        long ticksUntilTarget = targetTicks - currentTicks;
        if (ticksUntilTarget < 0L) {
            ticksUntilTarget += 24000L;
        }
        long realTimeSeconds = (long)((double)(ticksUntilTarget += (long)(occurrence * 24000)) * 0.05);
        return ZonedDateTime.now().plusSeconds(realTimeSeconds);
    }

    public static LocalTime getMinecraftTimeAt(World world, ZonedDateTime realTime) {
        long timeDiff = java.time.Duration.between(ZonedDateTime.now(), realTime).getSeconds();
        long ticksDiff = (long)((double)timeDiff / 0.05);
        long futureTicks = (world.getTime() + ticksDiff) % 24000L;
        long hours = (futureTicks / 1000L + 6L) % 24L;
        long minutes = futureTicks % 1000L * 60L / 1000L;
        return LocalTime.of((int)hours, (int)minutes);
    }

    public static long minecraftTimeToTicks(LocalTime mcTime) {
        int hours = mcTime.getHour();
        int minutes = mcTime.getMinute();
        if (hours < 6) {
            hours += 24;
        }
        long ticks = (long)(hours - 6) * 1000L + (long)minutes * 1000L / 60L;
        return ticks % 24000L;
    }
}

