/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils.migrations;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.gson.GsonConverter;
import me.playbosswar.com.utils.migrations.ExecutionMetadataMigration;
import me.playbosswar.com.utils.migrations.Migration;
import org.bukkit.plugin.Plugin;

public class MigrationManager {
    public static final int CURRENT_VERSION = 1;
    private final List<Migration> migrations = new ArrayList<Migration>();
    private final String pluginFolderPath;

    public MigrationManager(CommandTimerPlugin plugin) {
        this.pluginFolderPath = plugin.getDataFolder().getPath();
        this.registerMigrations();
    }

    private void registerMigrations() {
        this.migrations.add(new ExecutionMetadataMigration());
    }

    public void runMigrations() {
        File dir = new File(this.pluginFolderPath + "/timers");
        File[] files = dir.listFiles(file -> file.getName().endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            try (FileReader fr = new FileReader(file2);){
                int fileVersion;
                JsonObject json = new JsonParser().parse((Reader)fr).getAsJsonObject();
                int n = fileVersion = json.has("configVersion") ? json.get("configVersion").getAsInt() : 0;
                if (fileVersion >= 1) {
                    Messages.sendDebugConsole("Skipping migration for " + file2.getName() + " (v" + fileVersion + " >= v" + 1 + ")");
                    continue;
                }
                Messages.sendConsole("Migrating task file: " + file2.getName() + " (v" + fileVersion + " -> v" + 1 + ")");
                boolean failed = false;
                for (Migration migration : (Migration[])this.migrations.stream().filter(m -> m.getVersion() > fileVersion).sorted(Comparator.comparingInt(Migration::getVersion)).toArray(Migration[]::new)) {
                    try {
                        migration.migrate(file2, json);
                    }
                    catch (Exception e) {
                        Messages.sendConsole("Migration v" + migration.getVersion() + " failed for " + file2.getName() + ": " + e.getMessage());
                        e.printStackTrace();
                        failed = true;
                        break;
                    }
                }
                if (failed) {
                    Messages.sendConsole("Migration failed for " + file2.getName() + ". Disabling plugin...");
                    CommandTimerPlugin.getInstance().getServer().getPluginManager().disablePlugin((Plugin)CommandTimerPlugin.getInstance());
                    return;
                }
                Messages.sendConsole("Migration complete for " + file2.getName() + " (v" + fileVersion + " -> v" + 1 + ")");
                json.addProperty("configVersion", (Number)1);
                GsonConverter gson = new GsonConverter();
                try (FileWriter fw = new FileWriter(file2);){
                    fw.write(gson.toJson(json));
                    fw.flush();
                }
            }
            catch (IOException e) {
                Messages.sendConsole("Failed to process " + file2.getName() + ": " + e.getMessage());
            }
        }
    }

    public void rollbackToVersion(int targetVersion) {
        if (targetVersion < 0) {
            Messages.sendConsole("Invalid target version: " + targetVersion);
            return;
        }
        File dir = new File(this.pluginFolderPath + "/timers");
        File[] files = dir.listFiles(file -> file.getName().endsWith(".json"));
        if (files == null) {
            return;
        }
        for (File file2 : files) {
            try (FileReader fr = new FileReader(file2);){
                int fileVersion;
                JsonObject json = new JsonParser().parse((Reader)fr).getAsJsonObject();
                int n = fileVersion = json.has("configVersion") ? json.get("configVersion").getAsInt() : 0;
                if (fileVersion <= targetVersion) continue;
                Messages.sendConsole("Rolling back task file: " + file2.getName() + " (v" + fileVersion + " -> v" + targetVersion + ")");
                for (Migration migration : (Migration[])this.migrations.stream().filter(m -> m.getVersion() <= fileVersion && m.getVersion() > targetVersion).sorted((a, b) -> Integer.compare(b.getVersion(), a.getVersion())).toArray(Migration[]::new)) {
                    try {
                        Messages.sendConsole("Rolling back migration v" + migration.getVersion() + ": " + migration.getDescription());
                        migration.rollback(file2, json);
                    }
                    catch (Exception e) {
                        Messages.sendConsole("Rollback v" + migration.getVersion() + " failed for " + file2.getName() + ": " + e.getMessage());
                        e.printStackTrace();
                    }
                }
                if (targetVersion == 0) {
                    json.remove("configVersion");
                } else {
                    json.addProperty("configVersion", (Number)targetVersion);
                }
                GsonConverter gson = new GsonConverter();
                try (FileWriter fw = new FileWriter(file2);){
                    fw.write(gson.toJson(json));
                    fw.flush();
                }
            }
            catch (IOException e) {
                Messages.sendConsole("Failed to process " + file2.getName() + ": " + e.getMessage());
            }
        }
        Messages.sendConsole("Rollback to version " + targetVersion + " complete");
    }

    public int getCurrentVersion() {
        return 1;
    }

    public List<Migration> getMigrations() {
        return this.migrations;
    }
}

