/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import me.playbosswar.com.api.ConditionRule;
import org.jeasy.rules.api.Rule;
import org.jeasy.rules.core.RuleProxy;

public class ConditionRules
implements Iterable<ConditionRule> {
    private ArrayList<ConditionRule> rules = new ArrayList();

    public ConditionRules(ArrayList<ConditionRule> rules) {
        this.rules = new ArrayList<ConditionRule>(rules);
    }

    public ConditionRules(ConditionRule ... rules) {
        Collections.addAll(this.rules, rules);
    }

    public ConditionRules(Object ... rules) {
        this.register(rules);
    }

    public void register(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.add((ConditionRule)rule);
        }
    }

    public void unregister(Object ... rules) {
        Objects.requireNonNull(rules);
        for (Object rule : rules) {
            Objects.requireNonNull(rule);
            this.rules.remove(RuleProxy.asRule(rule));
        }
    }

    public void unregister(String ruleName) {
        Objects.requireNonNull(ruleName);
        Rule rule = this.findRuleByName(ruleName);
        if (rule != null) {
            this.unregister(rule);
        }
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    public void clear() {
        this.rules.clear();
    }

    public int size() {
        return this.rules.size();
    }

    @Override
    public Iterator<ConditionRule> iterator() {
        return this.rules.iterator();
    }

    private Rule findRuleByName(String ruleName) {
        return this.rules.stream().filter(rule -> rule.getName().equalsIgnoreCase(ruleName)).findFirst().orElse(null);
    }
}

