/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.util.List;
import me.playbosswar.com.commandtimer.sentry.BaggageHeader;
import me.playbosswar.com.commandtimer.sentry.Breadcrumb;
import me.playbosswar.com.commandtimer.sentry.CheckIn;
import me.playbosswar.com.commandtimer.sentry.Hint;
import me.playbosswar.com.commandtimer.sentry.ISentryClient;
import me.playbosswar.com.commandtimer.sentry.ISpan;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.ProfilingTraceData;
import me.playbosswar.com.commandtimer.sentry.ScopeCallback;
import me.playbosswar.com.commandtimer.sentry.SentryEnvelope;
import me.playbosswar.com.commandtimer.sentry.SentryEvent;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.SentryOptions;
import me.playbosswar.com.commandtimer.sentry.SentryTraceHeader;
import me.playbosswar.com.commandtimer.sentry.TraceContext;
import me.playbosswar.com.commandtimer.sentry.TransactionContext;
import me.playbosswar.com.commandtimer.sentry.TransactionOptions;
import me.playbosswar.com.commandtimer.sentry.UserFeedback;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryId;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryTransaction;
import me.playbosswar.com.commandtimer.sentry.protocol.User;
import me.playbosswar.com.commandtimer.sentry.transport.RateLimiter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IHub {
    public boolean isEnabled();

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event) {
        return this.captureEvent(event, new Hint());
    }

    @NotNull
    default public SentryId captureEvent(@NotNull SentryEvent event, @NotNull ScopeCallback callback) {
        return this.captureEvent(event, new Hint(), callback);
    }

    @NotNull
    public SentryId captureEvent(@NotNull SentryEvent var1, @Nullable Hint var2, @NotNull ScopeCallback var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message) {
        return this.captureMessage(message, SentryLevel.INFO);
    }

    @NotNull
    public SentryId captureMessage(@NotNull String var1, @NotNull SentryLevel var2);

    @NotNull
    public SentryId captureMessage(@NotNull String var1, @NotNull SentryLevel var2, @NotNull ScopeCallback var3);

    @NotNull
    default public SentryId captureMessage(@NotNull String message, @NotNull ScopeCallback callback) {
        return this.captureMessage(message, SentryLevel.INFO, callback);
    }

    @NotNull
    public SentryId captureEnvelope(@NotNull SentryEnvelope var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureEnvelope(@NotNull SentryEnvelope envelope) {
        return this.captureEnvelope(envelope, new Hint());
    }

    @NotNull
    public SentryId captureException(@NotNull Throwable var1, @Nullable Hint var2);

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable) {
        return this.captureException(throwable, new Hint());
    }

    @NotNull
    default public SentryId captureException(@NotNull Throwable throwable, @NotNull ScopeCallback callback) {
        return this.captureException(throwable, new Hint(), callback);
    }

    @NotNull
    public SentryId captureException(@NotNull Throwable var1, @Nullable Hint var2, @NotNull ScopeCallback var3);

    public void captureUserFeedback(@NotNull UserFeedback var1);

    public void startSession();

    public void endSession();

    public void close();

    public void addBreadcrumb(@NotNull Breadcrumb var1, @Nullable Hint var2);

    public void addBreadcrumb(@NotNull Breadcrumb var1);

    default public void addBreadcrumb(@NotNull String message) {
        this.addBreadcrumb(new Breadcrumb(message));
    }

    default public void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Breadcrumb breadcrumb = new Breadcrumb(message);
        breadcrumb.setCategory(category);
        this.addBreadcrumb(breadcrumb);
    }

    public void setLevel(@Nullable SentryLevel var1);

    public void setTransaction(@Nullable String var1);

    public void setUser(@Nullable User var1);

    public void setFingerprint(@NotNull List<String> var1);

    public void clearBreadcrumbs();

    public void setTag(@NotNull String var1, @NotNull String var2);

    public void removeTag(@NotNull String var1);

    public void setExtra(@NotNull String var1, @NotNull String var2);

    public void removeExtra(@NotNull String var1);

    @NotNull
    public SentryId getLastEventId();

    public void pushScope();

    public void popScope();

    public void withScope(@NotNull ScopeCallback var1);

    public void configureScope(@NotNull ScopeCallback var1);

    public void bindClient(@NotNull ISentryClient var1);

    public void flush(long var1);

    @NotNull
    public IHub clone();

    @ApiStatus.Internal
    @NotNull
    public SentryId captureTransaction(@NotNull SentryTransaction var1, @Nullable TraceContext var2, @Nullable Hint var3, @Nullable ProfilingTraceData var4);

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext, @Nullable Hint hint) {
        return this.captureTransaction(transaction, traceContext, hint, null);
    }

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable Hint hint) {
        return this.captureTransaction(transaction, null, hint);
    }

    @ApiStatus.Internal
    @NotNull
    default public SentryId captureTransaction(@NotNull SentryTransaction transaction, @Nullable TraceContext traceContext) {
        return this.captureTransaction(transaction, traceContext, null);
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return this.startTransaction(transactionContexts, new TransactionOptions());
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation) {
        return this.startTransaction(name, operation, new TransactionOptions());
    }

    @NotNull
    default public ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull TransactionOptions transactionOptions) {
        return this.startTransaction(new TransactionContext(name, operation), transactionOptions);
    }

    @NotNull
    public ITransaction startTransaction(@NotNull TransactionContext var1, @NotNull TransactionOptions var2);

    @Deprecated
    @Nullable
    public SentryTraceHeader traceHeaders();

    @ApiStatus.Internal
    public void setSpanContext(@NotNull Throwable var1, @NotNull ISpan var2, @NotNull String var3);

    @Nullable
    public ISpan getSpan();

    @ApiStatus.Internal
    @Nullable
    public ITransaction getTransaction();

    @NotNull
    public SentryOptions getOptions();

    @Nullable
    public Boolean isCrashedLastRun();

    public void reportFullyDisplayed();

    @Deprecated
    default public void reportFullDisplayed() {
        this.reportFullyDisplayed();
    }

    @Nullable
    public TransactionContext continueTrace(@Nullable String var1, @Nullable List<String> var2);

    @Nullable
    public SentryTraceHeader getTraceparent();

    @Nullable
    public BaggageHeader getBaggage();

    @ApiStatus.Experimental
    @NotNull
    public SentryId captureCheckIn(@NotNull CheckIn var1);

    @ApiStatus.Internal
    @Nullable
    public RateLimiter getRateLimiter();
}

