/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.JsonObjectReader;
import me.playbosswar.com.commandtimer.sentry.JsonSerializable;
import me.playbosswar.com.commandtimer.sentry.JsonUnknown;
import me.playbosswar.com.commandtimer.sentry.MonitorSchedule;
import me.playbosswar.com.commandtimer.sentry.ObjectWriter;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.vendor.gson.stream.JsonToken;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MonitorConfig
implements JsonUnknown,
JsonSerializable {
    @NotNull
    private MonitorSchedule schedule;
    @Nullable
    private Long checkinMargin;
    @Nullable
    private Long maxRuntime;
    @Nullable
    private String timezone;
    @Nullable
    private Map<String, Object> unknown;

    public MonitorConfig(@NotNull MonitorSchedule schedule) {
        this.schedule = schedule;
    }

    @NotNull
    public MonitorSchedule getSchedule() {
        return this.schedule;
    }

    public void setSchedule(@NotNull MonitorSchedule schedule) {
        this.schedule = schedule;
    }

    @Nullable
    public Long getCheckinMargin() {
        return this.checkinMargin;
    }

    public void setCheckinMargin(@Nullable Long checkinMargin) {
        this.checkinMargin = checkinMargin;
    }

    @Nullable
    public Long getMaxRuntime() {
        return this.maxRuntime;
    }

    public void setMaxRuntime(@Nullable Long maxRuntime) {
        this.maxRuntime = maxRuntime;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(@Nullable String timezone) {
        this.timezone = timezone;
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("schedule");
        this.schedule.serialize(writer, logger);
        if (this.checkinMargin != null) {
            writer.name("checkin_margin").value(this.checkinMargin);
        }
        if (this.maxRuntime != null) {
            writer.name("max_runtime").value(this.maxRuntime);
        }
        if (this.timezone != null) {
            writer.name("timezone").value(this.timezone);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String SCHEDULE = "schedule";
        public static final String CHECKIN_MARGIN = "checkin_margin";
        public static final String MAX_RUNTIME = "max_runtime";
        public static final String TIMEZONE = "timezone";
    }

    public static final class Deserializer
    implements JsonDeserializer<MonitorConfig> {
        @Override
        @NotNull
        public MonitorConfig deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            MonitorSchedule schedule = null;
            Long checkinMargin = null;
            Long maxRuntime = null;
            String timezone = null;
            HashMap<String, Object> unknown = null;
            reader.beginObject();
            block12: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "schedule": {
                        schedule = new MonitorSchedule.Deserializer().deserialize(reader, logger);
                        continue block12;
                    }
                    case "checkin_margin": {
                        checkinMargin = reader.nextLongOrNull();
                        continue block12;
                    }
                    case "max_runtime": {
                        maxRuntime = reader.nextLongOrNull();
                        continue block12;
                    }
                    case "timezone": {
                        timezone = reader.nextStringOrNull();
                        continue block12;
                    }
                }
                if (unknown == null) {
                    unknown = new HashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            reader.endObject();
            if (schedule == null) {
                String message = "Missing required field \"schedule\"";
                IllegalStateException exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            MonitorConfig monitorConfig = new MonitorConfig(schedule);
            monitorConfig.setCheckinMargin(checkinMargin);
            monitorConfig.setMaxRuntime(maxRuntime);
            monitorConfig.setTimezone(timezone);
            monitorConfig.setUnknown(unknown);
            return monitorConfig;
        }
    }
}

