/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry;

import java.io.IOException;
import java.util.Locale;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.JsonDeserializer;
import me.playbosswar.com.commandtimer.sentry.JsonObjectReader;
import me.playbosswar.com.commandtimer.sentry.JsonSerializable;
import me.playbosswar.com.commandtimer.sentry.ObjectWriter;
import me.playbosswar.com.commandtimer.sentry.SentryEvent;
import me.playbosswar.com.commandtimer.sentry.Session;
import me.playbosswar.com.commandtimer.sentry.clientreport.ClientReport;
import me.playbosswar.com.commandtimer.sentry.protocol.SentryTransaction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public enum SentryItemType implements JsonSerializable
{
    Session("session"),
    Event("event"),
    UserFeedback("user_report"),
    Attachment("attachment"),
    Transaction("transaction"),
    Profile("profile"),
    ClientReport("client_report"),
    ReplayEvent("replay_event"),
    ReplayRecording("replay_recording"),
    CheckIn("check_in"),
    Unknown("__unknown__");

    private final String itemType;

    public static SentryItemType resolve(Object item) {
        if (item instanceof SentryEvent) {
            return Event;
        }
        if (item instanceof SentryTransaction) {
            return Transaction;
        }
        if (item instanceof Session) {
            return Session;
        }
        if (item instanceof ClientReport) {
            return ClientReport;
        }
        return Attachment;
    }

    private SentryItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemType() {
        return this.itemType;
    }

    @NotNull
    public static SentryItemType valueOfLabel(String itemType) {
        for (SentryItemType sentryItemType : SentryItemType.values()) {
            if (!sentryItemType.itemType.equals(itemType)) continue;
            return sentryItemType;
        }
        return Unknown;
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.value(this.itemType);
    }

    static final class Deserializer
    implements JsonDeserializer<SentryItemType> {
        Deserializer() {
        }

        @Override
        @NotNull
        public SentryItemType deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            return SentryItemType.valueOfLabel(reader.nextString().toLowerCase(Locale.ROOT));
        }
    }
}

