/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.commandtimer.sentry.internal.debugmeta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import me.playbosswar.com.commandtimer.sentry.ILogger;
import me.playbosswar.com.commandtimer.sentry.SentryLevel;
import me.playbosswar.com.commandtimer.sentry.internal.debugmeta.IDebugMetaLoader;
import me.playbosswar.com.commandtimer.sentry.util.ClassLoaderUtils;
import me.playbosswar.com.commandtimer.sentry.util.DebugMetaPropertiesApplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ResourcesDebugMetaLoader
implements IDebugMetaLoader {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final ClassLoader classLoader;

    public ResourcesDebugMetaLoader(@NotNull ILogger logger) {
        this(logger, ResourcesDebugMetaLoader.class.getClassLoader());
    }

    ResourcesDebugMetaLoader(@NotNull ILogger logger, @Nullable ClassLoader classLoader) {
        this.logger = logger;
        this.classLoader = ClassLoaderUtils.classLoaderOrDefault(classLoader);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public Properties loadDebugMeta() {
        block18: {
            try (InputStream debugMetaStream = this.classLoader.getResourceAsStream(DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);){
                Properties properties;
                if (debugMetaStream == null) {
                    this.logger.log(SentryLevel.INFO, "%s file was not found.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                    break block18;
                }
                BufferedInputStream is = new BufferedInputStream(debugMetaStream);
                try {
                    Properties properties2 = new Properties();
                    properties2.load(is);
                    properties = properties2;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.logger.log(SentryLevel.ERROR, e, "Failed to load %s", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                        break block18;
                    }
                    catch (RuntimeException e) {
                        this.logger.log(SentryLevel.ERROR, e, "%s file is malformed.", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
                        break block18;
                    }
                }
                ((InputStream)is).close();
                return properties;
            }
            catch (IOException e) {
                this.logger.log(SentryLevel.ERROR, e, "Failed to load %s", DebugMetaPropertiesApplier.DEBUG_META_PROPERTIES_FILENAME);
            }
        }
        return null;
    }
}

