/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.conditionsengine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.NeededValue;
import me.playbosswar.com.api.events.EventCondition;
import me.playbosswar.com.api.events.EventConfiguration;
import me.playbosswar.com.api.events.EventExtension;
import me.playbosswar.com.api.events.EventSimpleCondition;
import me.playbosswar.com.conditionsengine.ConditionCompare;
import me.playbosswar.com.conditionsengine.conditions.ConditionHelpers;
import me.playbosswar.com.conditionsengine.validations.ConditionType;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskValidationHelpers;
import me.playbosswar.com.tasks.TasksManager;
import me.playbosswar.com.utils.Messages;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class EventsManager {
    private final TasksManager tasksManager;

    public EventsManager(TasksManager tasksManager) {
        this.tasksManager = tasksManager;
    }

    public void handleTriggeredEvent(ConditionExtension extension, EventExtension ev, ArrayList<NeededValue<?>> values) {
        List tasks = this.tasksManager.getLoadedTasks().stream().filter(t -> t.getEvents().stream().anyMatch(e -> e.getConditionGroup().equals(extension.getConditionGroupName()) && e.getEvent().equals(ev.getEventName()))).collect(Collectors.toList());
        HashMap<Task, List> events = new HashMap<Task, List>();
        for (Task t2 : tasks) {
            for (EventConfiguration e : t2.getEvents()) {
                if (!e.isActive()) {
                    Messages.sendDebugConsole("EVENT ENGINE: received event but ignoring because configuration is not active");
                    continue;
                }
                if (!e.getConditionGroup().equals(extension.getConditionGroupName())) {
                    Messages.sendDebugConsole("EVENT ENGINE: received event but condition group does not match");
                    continue;
                }
                if (!e.getEvent().equals(ev.getEventName())) {
                    Messages.sendDebugConsole("EVENT ENGINE: received event but condition name does not match");
                    continue;
                }
                events.putIfAbsent(t2, new ArrayList());
                ((List)events.get(t2)).add(e);
            }
        }
        events.forEach((task, configurations) -> {
            boolean valid;
            boolean hasMatchingConfiguration = configurations.stream().anyMatch(c -> this.processConfiguration(c.getCondition(), values));
            if (!hasMatchingConfiguration) {
                return;
            }
            Player p = null;
            UUID uuid = this.findPotentialPlayer(values);
            if (uuid != null) {
                p = Bukkit.getPlayer((UUID)uuid);
            }
            if (valid = TaskValidationHelpers.processCondition(task.getCondition(), p)) {
                task.getCommands().forEach(command -> this.tasksManager.processCommandExecution((Task)task, (TaskCommand)command));
            } else {
                Messages.sendDebugConsole("EVENT ENGINE: Processed event but conditions did not match");
            }
        });
    }

    private boolean checkSimpleCondition(EventSimpleCondition<?> simpleCondition, List<NeededValue<?>> values) {
        ConditionCompare compare = simpleCondition.getCompare();
        String fieldName = simpleCondition.getFieldName();
        Object expectedValue = simpleCondition.getValue();
        Optional<NeededValue> possibleValue = values.stream().filter(v -> v.getName().equals(fieldName)).findAny();
        if (!possibleValue.isPresent()) {
            return false;
        }
        NeededValue receivedValue = possibleValue.get();
        if (compare == null) {
            return receivedValue.getDefaultValue().equals(expectedValue);
        }
        if (receivedValue.getType() == Integer.class) {
            int expected;
            int value = (Integer)receivedValue.getDefaultValue();
            if (simpleCondition.getValue() instanceof Double) {
                Double conditionValue = (Double)simpleCondition.getValue();
                expected = conditionValue.intValue();
            } else {
                expected = (Integer)simpleCondition.getValue();
            }
            return ConditionHelpers.calculateConditionCompare(compare, value, expected);
        }
        if (receivedValue.getType() == Double.class) {
            double value = (Double)receivedValue.getDefaultValue();
            double expected = (Double)simpleCondition.getValue();
            return ConditionHelpers.calculateConditionCompare(compare, value, expected);
        }
        if (receivedValue.getType() == String.class) {
            String value = (String)receivedValue.getDefaultValue();
            String expected = (String)simpleCondition.getValue();
            return value.equals(expected);
        }
        if (receivedValue.getType() == World.class) {
            World value = (World)receivedValue.getDefaultValue();
            World expected = Bukkit.getWorld((String)simpleCondition.getValue().toString());
            return value.getName().equals(expected.getName());
        }
        return false;
    }

    @Nullable
    private UUID findPotentialPlayer(List<NeededValue<?>> values) {
        Optional<NeededValue> optionalPlayer = values.stream().filter(v -> v.getName().equals("@PLAYER_UUID")).findAny();
        return optionalPlayer.map(neededValue -> UUID.fromString((String)neededValue.getDefaultValue())).orElse(null);
    }

    private boolean processConfiguration(EventCondition condition, List<NeededValue<?>> values) {
        ConditionType conditionType = condition.getConditionType();
        if (conditionType.equals((Object)ConditionType.SIMPLE)) {
            return this.checkSimpleCondition((EventSimpleCondition)condition.getSimpleCondition(), values);
        }
        if (conditionType.equals((Object)ConditionType.NOT)) {
            return !this.checkSimpleCondition((EventSimpleCondition)condition.getSimpleCondition(), values);
        }
        if (conditionType.equals((Object)ConditionType.AND)) {
            return condition.getConditions().stream().allMatch(nestedCondition -> this.processConfiguration((EventCondition)nestedCondition, values));
        }
        if (conditionType.equals((Object)ConditionType.OR)) {
            return condition.getConditions().stream().anyMatch(nestedCondition -> this.processConfiguration((EventCondition)nestedCondition, values));
        }
        return false;
    }
}

