/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.events;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.api.ConditionExtension;
import me.playbosswar.com.api.events.EventCondition;
import me.playbosswar.com.api.events.EventExtension;
import me.playbosswar.com.conditionsengine.validations.ConditionType;
import me.playbosswar.com.gui.MenuUtils;
import me.playbosswar.com.gui.events.ConfigureEventValuesMenu;
import me.playbosswar.com.gui.events.EventConditionsMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ConfigureEventMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final ConditionExtension extension;
    private final EventExtension eventExtension;
    private final EventCondition condition;
    private final Callback<?> callback;
    private final Task task;

    public ConfigureEventMenu(Task task, ConditionExtension extension, EventExtension eventExtension, EventCondition condition, Callback<?> callback) {
        this.task = task;
        this.extension = extension;
        this.eventExtension = eventExtension;
        this.condition = condition;
        this.callback = callback;
        this.INVENTORY = SmartInventory.builder().id("configure-event").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.CONFIGURE_EVENT_GUI_TITLE).replace("$1", eventExtension.getEventName())).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        Callback<String> internalCallback = data -> this.INVENTORY.open(player);
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        ClickableItem conditionTypeItem = MenuUtils.getConditionTypeItem(this.condition, type -> {
            this.condition.setConditionType((ConditionType)((Object)type));
            this.task.storeInstance();
            new ConfigureEventMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, internalCallback).INVENTORY.open(player);
        });
        contents.set(1, 1, conditionTypeItem);
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> this.callback.execute(null)));
        if (this.condition.getConditionType().equals((Object)ConditionType.SIMPLE) || this.condition.getConditionType().equals((Object)ConditionType.NOT)) {
            String[] valuesLore = this.languageManager.getList(LanguageKey.CONFIGURE_EVENT_VALUES_ITEM_LORE).toArray(new String[0]);
            ItemStack valuesItem = Items.generateItem(LanguageKey.CONFIGURE_EVENT_VALUES_ITEM_TITLE, XMaterial.PAPER, valuesLore);
            contents.set(1, 2, ClickableItem.of(valuesItem, e -> new ConfigureEventValuesMenu((Task)this.task, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (EventCondition)this.condition, internalCallback).INVENTORY.open(player)));
            return;
        }
        String[] conditionPartsLore = this.languageManager.getList(LanguageKey.CONDITION_TYPE_LORE).toArray(new String[0]);
        ItemStack conditionsItem = Items.generateItem(LanguageKey.CONDITION_PARTS_TITLE, XMaterial.CRAFTING_TABLE, conditionPartsLore);
        ClickableItem clickableConditions = ClickableItem.of(conditionsItem, e -> new EventConditionsMenu((Task)this.task, (EventCondition)this.condition, (ConditionExtension)this.extension, (EventExtension)this.eventExtension, (Callback<String>)internalCallback).INVENTORY.open(player));
        contents.set(1, 2, clickableConditions);
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

