/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.conditionsengine.validations.Condition;
import me.playbosswar.com.gui.conditions.ConditionMenu;
import me.playbosswar.com.gui.events.MainEventsMenu;
import me.playbosswar.com.gui.tasks.AllTasksMenu;
import me.playbosswar.com.gui.tasks.commands.AllCommandsMenu;
import me.playbosswar.com.gui.tasks.general.GeneralLimitsMenu;
import me.playbosswar.com.gui.tasks.general.TextInputConversationPrompt;
import me.playbosswar.com.gui.tasks.scheduler.MainScheduleMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EditTaskMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;

    public EditTaskMenu(Task task) {
        this.task = task;
        this.INVENTORY = SmartInventory.builder().id("edit-task").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.EDIT_TASK_GUI_TITLE, task.getName())).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        ConversationFactory conversationFactory = new ConversationFactory(CommandTimerPlugin.getPlugin()).withModality(true).withFirstPrompt((Prompt)new TextInputConversationPrompt(LanguageKey.NEW_TASK_INPUT, text -> {
            this.task.setName((String)text);
            this.task.storeInstance();
            new EditTaskMenu((Task)this.task).INVENTORY.open(player);
        }));
        String[] nameLore = this.languageManager.getList(LanguageKey.CHANGE_TASK_DISPLAY_NAME_LORE).toArray(new String[0]);
        ItemStack nameItem = Items.generateItem(LanguageKey.CHANGE_TASK_DISPLAY_NAME_TITLE, XMaterial.PAPER, nameLore);
        ClickableItem clickableNameItem = ClickableItem.of(nameItem, e -> {
            player.closeInventory();
            conversationFactory.buildConversation((Conversable)player).begin();
        });
        contents.set(1, 1, clickableNameItem);
        String[] scheduleLore = this.languageManager.getList(LanguageKey.CHANGE_TASK_SCHEDULE_SETTINGS_LORE).toArray(new String[0]);
        ItemStack scheduleItem = Items.generateItem(LanguageKey.CHANGE_TASK_SCHEDULE_SETTINGS_TITLE, XMaterial.CLOCK, scheduleLore);
        ClickableItem clickableScheduleItem = ClickableItem.of(scheduleItem, e -> new MainScheduleMenu((Task)this.task).INVENTORY.open(player));
        contents.set(1, 2, clickableScheduleItem);
        String[] commandsLore = this.languageManager.getList(LanguageKey.CHANGE_TASK_COMMANDS_LORE).toArray(new String[0]);
        ItemStack commandsItem = Items.generateItem(LanguageKey.CHANGE_TASK_COMMANDS_TITLE, XMaterial.COMMAND_BLOCK, commandsLore);
        ClickableItem clickableCommandsItem = ClickableItem.of(commandsItem, e -> new AllCommandsMenu((Task)this.task).INVENTORY.open(player));
        contents.set(1, 3, clickableCommandsItem);
        String[] generalLimitsLore = this.languageManager.getList(LanguageKey.CHANGE_TASK_LIMITS_LORE).toArray(new String[0]);
        ItemStack generalLimitsItem = Items.generateItem(LanguageKey.CHANGE_TASK_LIMITS_TITLE, XMaterial.GOLD_INGOT, generalLimitsLore);
        ClickableItem clickableGeneralLimitsItem = ClickableItem.of(generalLimitsItem, e -> new GeneralLimitsMenu((Task)this.task).INVENTORY.open(player));
        contents.set(1, 4, clickableGeneralLimitsItem);
        Callback<String> conditionItemCallback = data -> this.INVENTORY.open(player);
        String[] conditionLore = this.languageManager.getList(LanguageKey.CHANGE_TASK_CONDITIONS_LORE).toArray(new String[0]);
        ItemStack conditionItem = Items.generateItem(LanguageKey.CHANGE_TASK_CONDITIONS_TITLE, XMaterial.COMPARATOR, conditionLore);
        ClickableItem clickableCondition = ClickableItem.of(conditionItem, e -> new ConditionMenu((Task)this.task, (Condition)this.task.getCondition(), conditionItemCallback).INVENTORY.open(player));
        contents.set(1, 5, clickableCondition);
        String[] eventsLore = this.languageManager.getList(LanguageKey.EVENTS_ITEM_LORE).toArray(new String[0]);
        ItemStack eventsItem = Items.generateItem(LanguageKey.EVENTS_ITEM_TITLE, XMaterial.BEACON, eventsLore);
        contents.set(1, 6, ClickableItem.of(eventsItem, e -> new MainEventsMenu((Task)this.task).INVENTORY.open(player)));
        boolean isActive = this.task.isActive();
        String[] activationLore = new String[]{"", this.languageManager.get(LanguageKey.TASK_ACTIVATION_LORE), "", this.languageManager.get(LanguageKey.GUI_CURRENT, isActive ? this.languageManager.get(LanguageKey.STATUS_ACTIVE) : this.languageManager.get(LanguageKey.STATUS_NOT_ACTIVE))};
        contents.set(1, 7, ClickableItem.of(Items.getToggleItem(LanguageKey.TASK_ACTIVATION_TITLE, activationLore, isActive), e -> {
            this.task.toggleActive();
            this.INVENTORY.open(player);
        }));
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new AllTasksMenu().INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }
}

