/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.commands;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import fr.minuskube.inv.content.Pagination;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.enums.Gender;
import me.playbosswar.com.gui.HorizontalIteratorWithBorder;
import me.playbosswar.com.gui.tasks.EditTaskMenu;
import me.playbosswar.com.gui.tasks.commands.CommandSettingsMenu;
import me.playbosswar.com.gui.tasks.commands.EditCommandMenu;
import me.playbosswar.com.gui.tasks.scheduler.EditIntervalMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AllCommandsMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;

    public AllCommandsMenu(Task task) {
        this.task = task;
        this.INVENTORY = SmartInventory.builder().id("task-commands").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(6, 9).title(this.languageManager.get(LanguageKey.TASK_COMMANDS_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        Pagination pagination = contents.pagination();
        pagination.setItems(this.getAllCommands(player));
        new HorizontalIteratorWithBorder(player, contents, this.INVENTORY);
        contents.set(5, 8, ClickableItem.of(Items.getBackItem(), e -> new EditTaskMenu((Task)this.task).INVENTORY.open(player)));
        String[] addItemLore = this.languageManager.getList(LanguageKey.ADD_COMMAND_LORE).toArray(new String[0]);
        ItemStack addItem = Items.generateItem(LanguageKey.ADD_COMMAND, XMaterial.ANVIL, addItemLore);
        ClickableItem clickableAddItem = ClickableItem.of(addItem, e -> {
            TaskCommand taskCommand = new TaskCommand("say This is my command", Gender.CONSOLE);
            this.task.addCommand(taskCommand);
            new EditCommandMenu((Task)this.task, (TaskCommand)taskCommand).INVENTORY.open(player);
        });
        contents.set(0, 0, clickableAddItem);
        ArrayList<String> selectModeLore = this.languageManager.getList(LanguageKey.GENDER_LORE);
        selectModeLore.add("");
        selectModeLore.add(this.languageManager.get(LanguageKey.GUI_CURRENT, this.task.getCommandExecutionMode().toString()));
        if (this.task.getCommandExecutionMode().equals((Object)CommandExecutionMode.INTERVAL)) {
            selectModeLore.add(this.languageManager.get(LanguageKey.CURRENT_INTERVAL, this.task.getCommandExecutionMode().equals((Object)CommandExecutionMode.INTERVAL) ? this.task.getCommandExecutionInterval().toString() : ""));
        }
        selectModeLore.add("");
        selectModeLore.add(this.languageManager.get(LanguageKey.LEFT_CLICK_SWITCH));
        selectModeLore.add(this.task.getCommandExecutionMode().equals((Object)CommandExecutionMode.INTERVAL) ? this.languageManager.get(LanguageKey.RIGHT_CLICK_CHANGE_INTERVAL) : "");
        ItemStack selectModeItem = Items.generateItem(LanguageKey.EXECUTION_MODE, XMaterial.DIAMOND_SHOVEL, selectModeLore.toArray(new String[0]));
        ItemMeta selectedModeItemMeta = selectModeItem.getItemMeta();
        selectedModeItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        ClickableItem clickableSelectModeItem = ClickableItem.of(selectModeItem, e -> {
            if (e.getClick().equals((Object)ClickType.LEFT)) {
                this.task.switchCommandExecutionMode();
                this.INVENTORY.open(player);
                return;
            }
            new EditIntervalMenu((Task)this.task, (TaskInterval)this.task.getCommandExecutionInterval(), (Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$null$2(org.bukkit.entity.Player org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)((AllCommandsMenu)this, (Player)player)).INVENTORY.open(player);
        });
        contents.set(0, 8, clickableSelectModeItem);
        ArrayList<String> commandSettingsLore = this.languageManager.getList(LanguageKey.OPEN_COMMANDS_SETTINGS_LORE);
        commandSettingsLore.add("");
        commandSettingsLore.add(this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT));
        ItemStack commandSettingsItem = Items.generateItem(LanguageKey.OPEN_COMMANDS_SETTINGS, XMaterial.REPEATER, commandSettingsLore.toArray(new String[0]));
        ClickableItem clickableCommandSettingsItem = ClickableItem.of(commandSettingsItem, e -> new CommandSettingsMenu((Task)this.task).INVENTORY.open(player));
        contents.set(5, 0, clickableCommandSettingsItem);
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private ClickableItem[] getAllCommands(Player p) {
        List<TaskCommand> commands = this.task.getCommands();
        if (commands == null) {
            return new ClickableItem[0];
        }
        ClickableItem[] items = new ClickableItem[commands.size()];
        for (int i = 0; i < items.length; ++i) {
            TaskCommand taskCommand = commands.get(i);
            String command = taskCommand.getCommand();
            String[] lore = new String[]{"", this.languageManager.get(LanguageKey.GENDER, taskCommand.getGender().toString()), this.languageManager.get(LanguageKey.ITEM_DESCRIPTION_LORE, taskCommand.getDescription()), "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT), this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE)};
            ItemStack item = Items.generateItem("\u00a7b" + command, XMaterial.COMMAND_BLOCK_MINECART, lore);
            items[i] = ClickableItem.of(item, e -> {
                if (e.getClick().equals((Object)ClickType.LEFT)) {
                    new EditCommandMenu((Task)this.task, (TaskCommand)taskCommand).INVENTORY.open(p);
                    return;
                }
                if (e.getClick().equals((Object)ClickType.RIGHT)) {
                    this.task.removeCommand(taskCommand);
                    this.INVENTORY.open(p);
                }
            });
        }
        return items;
    }

    private /* synthetic */ void lambda$null$2(Player player, InventoryClickEvent e2) {
        new AllCommandsMenu((Task)this.task).INVENTORY.open(player);
    }
}

