/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.commands;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.enums.Gender;
import me.playbosswar.com.gui.tasks.commands.AllCommandsMenu;
import me.playbosswar.com.gui.tasks.general.TextInputConversationPrompt;
import me.playbosswar.com.gui.tasks.scheduler.EditIntervalMenu;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.utils.Items;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class EditCommandMenu
implements InventoryProvider {
    public SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;
    private final TaskCommand taskCommand;

    public EditCommandMenu(Task task, TaskCommand taskCommand) {
        this.task = task;
        this.taskCommand = taskCommand;
        this.INVENTORY = SmartInventory.builder().id("edit-command").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.EDIT_COMMAND_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        String[] editCommandLore = new String[]{"", this.languageManager.get(LanguageKey.EDIT_COMMAND_DESCRIPTION), "", this.languageManager.get(LanguageKey.GUI_CURRENT, this.taskCommand.getCommand())};
        ConversationFactory conversationFactory = new ConversationFactory(CommandTimerPlugin.getPlugin()).withModality(true).withFirstPrompt((Prompt)new TextInputConversationPrompt(LanguageKey.ENTER_COMMAND_INPUT, text -> {
            this.taskCommand.setCommand((String)text);
            this.task.storeInstance();
            new EditCommandMenu((Task)this.task, (TaskCommand)this.taskCommand).INVENTORY.open(player);
        }));
        ItemStack editCommandItem = Items.generateItem(LanguageKey.CHANGE_COMMAND, XMaterial.PAPER, editCommandLore);
        ClickableItem clickableCommandItem = ClickableItem.of(editCommandItem, e -> {
            conversationFactory.buildConversation((Conversable)player).begin();
            player.closeInventory();
        });
        contents.set(1, 1, clickableCommandItem);
        ItemStack genderItem = Items.generateItem(LanguageKey.GENDER_ITEM, XMaterial.CHAINMAIL_HELMET, this.languageManager.getList(LanguageKey.GENDER_SELECTOR_LORE, this.taskCommand.getGender().toString()).toArray(new String[0]));
        ClickableItem clickableGenderItem = ClickableItem.of(genderItem, e -> {
            this.taskCommand.toggleGender();
            this.task.storeInstance();
            this.INVENTORY.open(player);
        });
        contents.set(1, 2, clickableGenderItem);
        ItemStack descriptionItem = Items.generateItem(LanguageKey.DESCRIPTION_ITEM, XMaterial.BOOK, this.languageManager.getList(LanguageKey.DESCRIPTION_LORE, this.taskCommand.getDescription()).toArray(new String[0]));
        ConversationFactory descriptionConversationHistory = new ConversationFactory(CommandTimerPlugin.getPlugin()).withModality(true).withFirstPrompt((Prompt)new TextInputConversationPrompt(LanguageKey.EDIT_COMMAND_DESCRIPTION, text -> {
            this.taskCommand.setDescription((String)text);
            this.task.storeInstance();
            new EditCommandMenu((Task)this.task, (TaskCommand)this.taskCommand).INVENTORY.open(player);
        }));
        ClickableItem clickableDescriptionItem = ClickableItem.of(descriptionItem, e -> {
            descriptionConversationHistory.buildConversation((Conversable)player).begin();
            player.closeInventory();
        });
        contents.set(1, 3, clickableDescriptionItem);
        if (!this.taskCommand.getGender().equals((Object)Gender.CONSOLE)) {
            ItemStack intervalItem = Items.generateItem(LanguageKey.TASK_INTERVAL_ITEM_TITLE, XMaterial.CLOCK, this.languageManager.getList(LanguageKey.COMMAND_INTERVAL_LORE, this.taskCommand.getInterval().toString()).toArray(new String[0]));
            ClickableItem clickableIntervalItem = ClickableItem.of(intervalItem, e -> new EditIntervalMenu((Task)this.task, (TaskInterval)this.taskCommand.getInterval(), (Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$null$5(org.bukkit.entity.Player org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)((EditCommandMenu)this, (Player)player)).INVENTORY.open(player));
            contents.set(1, 4, clickableIntervalItem);
        }
        if (this.task.getCommandExecutionMode().equals((Object)CommandExecutionMode.ORDERED)) {
            ItemStack delayItem = Items.generateItem(LanguageKey.COMMAND_DELAY_TITLE, XMaterial.CLOCK, this.languageManager.getList(LanguageKey.COMMAND_DELAY_LORE, this.taskCommand.getDelay().toString()).toArray(new String[0]));
            ClickableItem clickableDelayItem = ClickableItem.of(delayItem, e -> new EditIntervalMenu((Task)this.task, (TaskInterval)this.taskCommand.getDelay(), (Consumer<InventoryClickEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$null$7(org.bukkit.entity.Player org.bukkit.event.inventory.InventoryClickEvent ), (Lorg/bukkit/event/inventory/InventoryClickEvent;)V)((EditCommandMenu)this, (Player)player)).INVENTORY.open(player));
            if (!this.taskCommand.getGender().equals((Object)Gender.CONSOLE)) {
                contents.set(1, 5, clickableDelayItem);
            } else {
                contents.set(1, 4, clickableDelayItem);
            }
        }
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new AllCommandsMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private /* synthetic */ void lambda$null$7(Player player, InventoryClickEvent ev) {
        new EditCommandMenu((Task)this.task, (TaskCommand)this.taskCommand).INVENTORY.open(player);
    }

    private /* synthetic */ void lambda$null$5(Player player, InventoryClickEvent ev) {
        new EditCommandMenu((Task)this.task, (TaskCommand)this.taskCommand).INVENTORY.open(player);
    }
}

