/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.scheduler;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.util.function.Consumer;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.tasks.general.ClickableTextInputButton;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskInterval;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class EditIntervalMenu
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;
    private final TaskInterval interval;
    private final Consumer<InventoryClickEvent> consumer;
    private final String[] clockLore = new String[]{"", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT)};

    public EditIntervalMenu(Task task, TaskInterval interval, Consumer<InventoryClickEvent> consumer) {
        this.task = task;
        this.interval = interval;
        this.consumer = consumer;
        this.INVENTORY = SmartInventory.builder().id("task-interval").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(5, 9).title(this.languageManager.get(LanguageKey.TASK_INTERVAL_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fill(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        contents.set(1, 1, ClickableItem.of(Items.getAddItem(), e -> {
            this.interval.incrementDays();
            this.task.storeInstance();
            this.refresh(player);
        }));
        ClickableTextInputButton daysClocks = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.DAYS_LABEL, String.valueOf(this.interval.getDays())), XMaterial.CLOCK, this.clockLore), data -> {
            int days = Integer.parseInt(data);
            this.interval.setDays(days);
            this.task.storeInstance();
            this.refresh(player);
        });
        contents.set(2, 1, daysClocks.getItem());
        contents.set(3, 1, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.interval.decrementDays();
            this.task.storeInstance();
            this.refresh(player);
        }));
        contents.set(1, 3, ClickableItem.of(Items.getAddItem(), e -> {
            this.interval.incrementHours();
            this.task.storeInstance();
            this.refresh(player);
        }));
        ClickableTextInputButton hoursClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.HOURS_LABEL, String.valueOf(this.interval.getHours())), XMaterial.CLOCK, this.clockLore), data -> {
            int hours = Integer.parseInt(data);
            this.interval.setHours(hours);
            this.task.storeInstance();
            this.refresh(player);
        });
        contents.set(2, 3, hoursClock.getItem());
        contents.set(3, 3, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.interval.decrementHours();
            this.task.storeInstance();
            this.refresh(player);
        }));
        contents.set(1, 5, ClickableItem.of(Items.getAddItem(), e -> {
            this.interval.incrementMinutes();
            this.task.storeInstance();
            this.refresh(player);
        }));
        ClickableTextInputButton minutesClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.MINUTES_LABEL, String.valueOf(this.interval.getMinutes())), XMaterial.CLOCK, this.clockLore), data -> {
            int minutes = Integer.parseInt(data);
            this.interval.setMinutes(minutes);
            this.task.storeInstance();
            this.refresh(player);
        });
        contents.set(2, 5, minutesClock.getItem());
        contents.set(3, 5, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.interval.decrementMinutes();
            this.task.storeInstance();
            this.refresh(player);
        }));
        contents.set(1, 7, ClickableItem.of(Items.getAddItem(), e -> {
            this.interval.incrementSeconds();
            this.task.storeInstance();
            this.refresh(player);
        }));
        ClickableTextInputButton secondsClock = new ClickableTextInputButton(Items.generateItem(this.languageManager.get(LanguageKey.SECONDS_LABEL, String.valueOf(this.interval.getSeconds())), XMaterial.CLOCK, this.clockLore), data -> {
            int seconds = Integer.parseInt(data);
            this.interval.setSeconds(seconds);
            this.task.storeInstance();
            this.refresh(player);
        });
        contents.set(2, 7, secondsClock.getItem());
        contents.set(3, 7, ClickableItem.of(Items.getSubstractItem(), e -> {
            this.interval.decrementSeconds();
            this.task.storeInstance();
            this.refresh(player);
        }));
        contents.set(4, 8, ClickableItem.of(Items.getBackItem(), this.consumer));
    }

    @Override
    public void update(Player player, InventoryContents contents) {
    }

    private void refresh(Player player) {
        this.INVENTORY.open(player);
    }
}

