/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.gui.tasks.scheduler;

import com.cryptomorin.xseries.XMaterial;
import fr.minuskube.inv.ClickableItem;
import fr.minuskube.inv.SmartInventory;
import fr.minuskube.inv.content.InventoryContents;
import fr.minuskube.inv.content.InventoryProvider;
import java.util.ArrayList;
import java.util.List;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.gui.tasks.scheduler.EditHourMenu;
import me.playbosswar.com.gui.tasks.scheduler.EditTimesMenu;
import me.playbosswar.com.gui.worlds.WorldSelector;
import me.playbosswar.com.language.LanguageKey;
import me.playbosswar.com.language.LanguageManager;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.utils.Callback;
import me.playbosswar.com.utils.Items;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class EditSpecificTimeMenu
implements InventoryProvider {
    public final SmartInventory INVENTORY;
    private final LanguageManager languageManager = CommandTimerPlugin.getLanguageManager();
    private final Task task;
    private final TaskTime taskTime;

    public EditSpecificTimeMenu(Task task, TaskTime taskTime) {
        this.task = task;
        this.taskTime = taskTime;
        this.INVENTORY = SmartInventory.builder().id("task-times-specific").provider(this).manager(CommandTimerPlugin.getInstance().getInventoryManager()).size(3, 9).title(this.languageManager.get(LanguageKey.SPECIFIC_TIME_GUI_TITLE)).build();
    }

    @Override
    public void init(Player player, InventoryContents contents) {
        contents.fillBorders(ClickableItem.empty(XMaterial.BLUE_STAINED_GLASS_PANE.parseItem()));
        String[] time1Lore = new String[]{"", this.languageManager.get(LanguageKey.GUI_CURRENT, this.taskTime.getTime1() == null ? this.languageManager.get(LanguageKey.NOT_SET) : this.taskTime.getTime1().toString()), "", this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT)};
        ItemStack time1Item = Items.generateItem(LanguageKey.TIME_ONE_TITLE, XMaterial.CLOCK, time1Lore);
        ClickableItem clickableTime1Item = ClickableItem.of(time1Item, e -> new EditHourMenu((Task)this.task, (TaskTime)this.taskTime, (boolean)false).INVENTORY.open(player));
        contents.set(1, 1, clickableTime1Item);
        ArrayList<String> time2Lore = this.languageManager.getList(LanguageKey.TIME_TWO_LORE, this.taskTime.getTime2() == null ? "Not set" : this.taskTime.getTime2().toString());
        time2Lore.add("");
        time2Lore.add(this.languageManager.get(LanguageKey.LEFT_CLICK_EDIT));
        time2Lore.add(this.languageManager.get(LanguageKey.RIGHT_CLICK_DELETE));
        ItemStack time2Item = Items.generateItem(LanguageKey.TIME_TWO_TITLE, XMaterial.CLOCK, time2Lore.toArray(new String[0]));
        ClickableItem clickableTime2Item = ClickableItem.of(time2Item, e -> {
            if (e.isLeftClick()) {
                new EditHourMenu((Task)this.task, (TaskTime)this.taskTime, (boolean)true).INVENTORY.open(player);
            }
            if (e.isRightClick()) {
                this.taskTime.setTime2(null);
                this.task.storeInstance();
                this.INVENTORY.open(player);
            }
        });
        contents.set(1, 2, clickableTime2Item);
        String[] minecraftTimeLore = this.languageManager.getList(LanguageKey.MINECRAFT_TIME_LORE).toArray(new String[0]);
        ItemStack minecraftTimeItem = Items.getToggleItem(LanguageKey.MINECRAFT_TIME_TITLE, minecraftTimeLore, this.taskTime.isMinecraftTime());
        contents.set(1, 3, ClickableItem.of(minecraftTimeItem, e -> {
            this.taskTime.toggleMinecraftTime();
            this.task.storeInstance();
            this.INVENTORY.open(player);
        }));
        if (this.taskTime.isMinecraftTime()) {
            String[] worldLore = this.languageManager.getList(LanguageKey.MINECRAFT_TIME_LORE, this.taskTime.getWorld() == null ? this.languageManager.get(LanguageKey.NOT_SET) : this.taskTime.getWorld()).toArray(new String[0]);
            ItemStack worldItem = Items.generateItem(LanguageKey.USED_MINECRAFT_WORLD, XMaterial.MAP, worldLore);
            Callback<List> worldCallback = worlds -> {
                this.taskTime.setWorld((String)worlds.get(0));
                this.task.storeInstance();
                new EditSpecificTimeMenu((Task)this.task, (TaskTime)this.taskTime).INVENTORY.open(player);
            };
            ArrayList<String> worlds2 = new ArrayList<String>();
            worlds2.add(this.taskTime.getWorld());
            contents.set(1, 4, ClickableItem.of(worldItem, e -> new WorldSelector((Callback<List<String>>)worldCallback, (List<String>)worlds, (boolean)false).INVENTORY.open(player)));
        }
        contents.set(2, 8, ClickableItem.of(Items.getBackItem(), e -> new EditTimesMenu((Task)this.task).INVENTORY.open(player)));
    }

    @Override
    public void update(Player player, InventoryContents inventoryContents) {
    }
}

