/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.tasks;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.TimerTask;
import me.playbosswar.com.CommandTimerPlugin;
import me.playbosswar.com.commandtimer.sentry.ITransaction;
import me.playbosswar.com.commandtimer.sentry.Sentry;
import me.playbosswar.com.enums.CommandExecutionMode;
import me.playbosswar.com.tasks.CommandIntervalExecutorRunnable;
import me.playbosswar.com.tasks.Task;
import me.playbosswar.com.tasks.TaskCommand;
import me.playbosswar.com.tasks.TaskTime;
import me.playbosswar.com.tasks.TasksManager;
import me.playbosswar.com.utils.Messages;
import me.playbosswar.com.utils.TaskTimeUtils;
import me.playbosswar.com.utils.TaskUtils;
import me.playbosswar.com.utils.Tools;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class TaskRunner
implements Runnable {
    private final TasksManager tasksManager;

    public TaskRunner(TasksManager tasksManager) {
        this.tasksManager = tasksManager;
    }

    private void processTask(Task task) {
        if (this.tasksManager.stopRunner) {
            return;
        }
        Messages.sendDebugConsole("Checking if " + task.getName() + " can be executed");
        if (!task.isActive()) {
            Messages.sendDebugConsole("Task is not active");
            return;
        }
        if (!TaskUtils.checkTaskDaysContainToday(task)) {
            Messages.sendDebugConsole("Command can not be executed today");
            return;
        }
        if (task.getTimesExecuted() >= task.getExecutionLimit() && task.getExecutionLimit() != -1) {
            Messages.sendDebugConsole("Task reached the maximum execution limit");
            return;
        }
        if (!Tools.randomCheck(task.getRandom())) {
            Messages.sendDebugConsole("Task has a random execution chance");
            return;
        }
        boolean blockTime = true;
        if (!task.getTimes().isEmpty()) {
            Messages.sendDebugConsole("Task is time related, checking if can be executed now");
            for (TaskTime taskTime : task.getTimes()) {
                String time1Format;
                if (taskTime.isMinecraftTime()) {
                    Messages.sendDebugConsole("Task is using minecraft time");
                    World world = Bukkit.getWorld((String)(taskTime.getWorld() == null ? "world" : taskTime.getWorld()));
                    String minecraftTime = Tools.calculateWorldTime(world);
                    Messages.sendDebugConsole("Current minecraft time is " + minecraftTime);
                    LocalTime current = LocalTime.parse(minecraftTime);
                    if (taskTime.isRange()) {
                        boolean hasPassedInterval;
                        LocalTime startRange = taskTime.getTime1();
                        LocalTime endRange = taskTime.getTime2();
                        if (!current.isBefore(endRange) || !current.isAfter(startRange) || !(hasPassedInterval = TaskTimeUtils.hasPassedInterval(task))) continue;
                        blockTime = false;
                        continue;
                    }
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
                    if (!minecraftTime.equals(taskTime.getTime1().format(formatter))) continue;
                    blockTime = false;
                    continue;
                }
                Messages.sendDebugConsole("Found time, checking if execution is needed");
                LocalTime current = LocalTime.now().withNano(0);
                if (taskTime.isRange()) {
                    Messages.sendDebugConsole("Found time range");
                    LocalTime startRange = taskTime.getTime1();
                    LocalTime endRange = taskTime.getTime2();
                    if (!current.isBefore(endRange) || !current.isAfter(startRange)) continue;
                    Messages.sendDebugConsole("Time is inside time range");
                    boolean hasPassedInterval = TaskTimeUtils.hasPassedInterval(task);
                    if (!hasPassedInterval) continue;
                    Messages.sendDebugConsole("Interval has passed, time range can be executed");
                    blockTime = false;
                    continue;
                }
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");
                String currentFormat = current.format(formatter);
                if (!currentFormat.equals(time1Format = taskTime.getTime1().format(formatter))) {
                    Messages.sendDebugConsole("Time " + currentFormat + " does not correspond to " + time1Format);
                    continue;
                }
                blockTime = false;
            }
        } else {
            if (task.getInterval().toSeconds() == 0 && !task.getEvents().isEmpty()) {
                Messages.sendDebugConsole("Timer has no interval set and uses events, skipping");
                return;
            }
            blockTime = false;
            boolean hasPassedInterval = TaskTimeUtils.hasPassedInterval(task);
            if (!hasPassedInterval) {
                Messages.sendDebugConsole("Timer has been executed before");
                return;
            }
        }
        if (blockTime) {
            Messages.sendDebugConsole("Execution has been blocked because times do not correspond");
            return;
        }
        CommandExecutionMode executionMode = task.getCommandExecutionMode();
        if (executionMode.equals((Object)CommandExecutionMode.INTERVAL)) {
            CommandTimerPlugin.getScheduler().runTaskTimer(new CommandIntervalExecutorRunnable(task), 1L, (long)task.getCommandExecutionInterval().toSeconds() * 20L);
            return;
        }
        boolean hasDelayedCommands = task.getCommands().stream().anyMatch(c -> c.getDelay().toSeconds() > 0);
        if (executionMode.equals((Object)CommandExecutionMode.ORDERED) && hasDelayedCommands) {
            int[] accumulatedDelaySeconds = new int[]{0};
            task.getCommands().forEach(command -> {
                CommandTimerPlugin.getScheduler().runTaskLater(() -> this.tasksManager.processCommandExecution(task, (TaskCommand)command), 20L * (long)accumulatedDelaySeconds[0] + 1L);
                accumulatedDelaySeconds[0] = accumulatedDelaySeconds[0] + command.getDelay().toSeconds();
            });
            return;
        }
        int selectedCommandIndex = this.tasksManager.getNextTaskCommandIndex(task);
        if (selectedCommandIndex == -1) {
            task.setLastExecutedCommandIndex(0);
            CommandTimerPlugin.getScheduler().runTask(() -> task.getCommands().forEach(command -> this.tasksManager.processCommandExecution(task, (TaskCommand)command)));
        } else {
            TaskCommand taskCommand = task.getCommands().get(selectedCommandIndex);
            task.setLastExecutedCommandIndex(task.getCommands().indexOf(taskCommand));
            CommandTimerPlugin.getScheduler().runTask(() -> this.tasksManager.processCommandExecution(task, taskCommand));
        }
        task.storeInstance();
    }

    @Override
    public void run() {
        CommandTimerPlugin.getScheduler().runTaskTimer(new TimerTask(){

            @Override
            public void run() {
                if (((TaskRunner)TaskRunner.this).tasksManager.stopRunner) {
                    Messages.sendDebugConsole("Ignoring execution because manager has been stopped");
                    return;
                }
                List<Task> tasks = CommandTimerPlugin.getInstance().getTasksManager().getLoadedTasks();
                tasks.forEach(task -> {
                    ITransaction transaction = Sentry.startTransaction("processTask()", "task");
                    TaskRunner.this.processTask(task);
                    transaction.finish();
                });
            }
        }, System.currentTimeMillis() % 20L + 1L, 20L);
    }
}

