/*
 * Decompiled with CFR 0.152.
 */
package me.playbosswar.com.utils;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import me.playbosswar.com.tasks.Task;

public class TaskUtils {
    public static boolean checkTaskDaysContainToday(Task task) {
        DayOfWeek today = LocalDate.now().getDayOfWeek();
        return task.getDays().contains(today);
    }

    public static DayOfWeek getFirstNextDow(Task task) {
        if (task.getDays().isEmpty()) {
            return null;
        }
        List dayValues = task.getDays().stream().map(DayOfWeek::getValue).collect(Collectors.toList());
        DayOfWeek today = LocalDate.now().getDayOfWeek();
        int todayValue = today.getValue();
        int foundDay = -1;
        while (foundDay == -1) {
            if (dayValues.contains(todayValue)) {
                foundDay = todayValue;
                continue;
            }
            if (++todayValue <= 7) continue;
            todayValue = 1;
        }
        return DayOfWeek.of(todayValue);
    }
}

