package dev.azuuure.playerlist.listener;

import dev.azuuure.playerlist.BetterPlayerList;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;

public final class ClientTickEventsListener {

    private final BetterPlayerList mod;
    private boolean previouslyPressed;

    public ClientTickEventsListener() {
        this.mod = BetterPlayerList.getInstance();
        this.previouslyPressed = false;
    }

    public void register() {
        ClientTickEvents.END_CLIENT_TICK.register(this::handle);
    }

    private void handle(class_310 client) {
        var pressed = client.field_1690.field_1907.method_1434();
        if (mod.getSettings().shouldHold()) {
            mod.getSettings().setShouldDisplayList(pressed);
            return;
        }

        if (pressed && !previouslyPressed) {
            var current = mod.getSettings().shouldDisplayList();
            mod.getSettings().setShouldDisplayList(!current);
        }

        previouslyPressed = pressed;
    }
}
