package dev.azuuure.playerlist.mixin;

import dev.azuuure.playerlist.BetterPlayerList;
import dev.azuuure.playerlist.settings.latency.LatencyDisplayMode;
import dev.azuuure.playerlist.utils.ColorUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_640;
import org.joml.Matrix3x2fStack;
import org.objectweb.asm.Opcodes;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.*;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_355.class)
public abstract class PlayerListHudMixin {

    @Shadow @Final
    private class_310 client;

    @Shadow
    private class_2561 header;

    @Shadow
    private class_2561 footer;

    @Redirect(
            method = "render",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/gui/hud/PlayerListHud;header:Lnet/minecraft/text/Text;",
                    opcode = Opcodes.GETFIELD
            )
    )
    public class_2561 redirectHeader(class_355 instance) {
        if (!BetterPlayerList.getInstance().getSettings().isHeaderEnabled()) {
            return null;
        }

        return header;
    }

    @Redirect(
            method = "render",
            at = @At(
                    value = "FIELD",
                    target = "Lnet/minecraft/client/gui/hud/PlayerListHud;footer:Lnet/minecraft/text/Text;",
                    opcode = Opcodes.GETFIELD
            )
    )
    public class_2561 redirectFooter(class_355 instance) {
        if (!BetterPlayerList.getInstance().getSettings().isFooterEnabled()) {
            return null;
        }

        return footer;
    }

    @Inject(method = "renderLatencyIcon", at = @At("HEAD"), cancellable = true)
    public void renderLatencyAsText(class_332 ctx, int width, int x, int y, class_640 entry, CallbackInfo ci) {
        var mod = BetterPlayerList.getInstance();
        var settings = mod.getSettings();

        LatencyDisplayMode mode = settings.getLatencyDisplayMode();
        if (mode == LatencyDisplayMode.VANILLA) {
            return;
        }

        int ms = Math.min(9999, entry.method_2959());
        int color = ColorUtils.latencyToColor(ms);
        var renderer = client.field_1772;
        boolean showUnit = mode == LatencyDisplayMode.COMPACT_WITH_UNIT
                || mode == LatencyDisplayMode.FULL_SIZE;

        class_2561 text;
        if (showUnit) {
            text = class_2561.method_43470(ms + "ms")
                    .method_54663(color);
        } else {
            text = class_2561.method_43470(String.valueOf(ms))
                    .method_54663(color);
        }

        switch (mode) {
            case COMPACT_WITH_UNIT:
            case COMPACT: {
                float scale = 0.5f;
                Matrix3x2fStack matrices = ctx.method_51448();
                matrices.pushMatrix();
                matrices.scale(scale);

                int maxX = (int)((x + width - 2) / scale);
                int drawX = maxX - renderer.method_27525(text);
                int drawY = (int)(y / scale + 5);
                ctx.method_27535(renderer, text, drawX, drawY, -1);

                matrices.popMatrix();
                break;
            }
            case FULL_SIZE: {
                int drawX = (x + width) - renderer.method_27525(text);
                ctx.method_27535(renderer, text, drawX, y, -1);
                break;
            }
            case DISABLED: {
                break;
            }
        }

        ci.cancel();
    }

    // targets this line:
    //   int m = Math.min(p * ((bl ? 9 : 0) + j + q + 13), scaledWindowWidth - 50) / p;
    @ModifyConstant(
            method = "render",
            constant = @Constant(intValue = 13)
    )
    public int expandEntries(int constant) {
        var mode = BetterPlayerList
                .getInstance()
                .getSettings()
                .getLatencyDisplayMode();

        switch (mode) {
            case COMPACT: {
                constant += 5;
                break;
            }
            case COMPACT_WITH_UNIT: {
                constant += 10;
                break;
            }
            case DISABLED: {
                constant -= 5;
                break;
            }
            case FULL_SIZE: {
                constant += 26;
                break;
            }
            default: {
                // noop
            }
        }

        return constant;
    }

    @ModifyVariable(
            method = "render",
            at = @At("STORE"),
            ordinal = 0
    )
    public boolean renderPlayerHeads(boolean value) {
        var settings = BetterPlayerList.getInstance().getSettings();

        if (!settings.shouldRenderHeads()) {
            return false;
        }

        if (settings.forcesHeads()) {
            return true;
        }

        return value;
    }
}
