package dev.azuuure.playerlist.screen;

import dev.azuuure.playerlist.BetterPlayerList;
import dev.azuuure.playerlist.settings.BetterPlayerListSettings;
import dev.azuuure.playerlist.settings.latency.LatencyDisplayMode;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5676;
import net.minecraft.class_7919;

public final class BetterPlayerListScreen extends class_4667 {

    private final BetterPlayerListSettings settings;

    public BetterPlayerListScreen(class_437 parent) {
        super(
                parent,
                class_310.method_1551().field_1690,
                class_2561.method_43471("better-player-list.settings.title")
        );

        this.settings = BetterPlayerList.getInstance().getSettings();
    }

    @Override
    protected void method_60325() {
        if (field_51824 == null) {
            return;
        }

        // just in case because i do not trust minecraft
        var client = this.field_22787 != null ? this.field_22787 : class_310.method_1551();
        var header = class_5676.method_32614(settings.isHeaderEnabled())
                .method_32618((v) ->
                        class_7919.method_47407(
                                class_2561.method_43471("better-player-list.settings.header.tooltip")
                        )
                ).method_57720(class_2561.method_43471("better-player-list.settings.header"),
                        (w, v) -> settings.setHeader(v));

        var footer = class_5676.method_32614(settings.isFooterEnabled())
                .method_32618((v) ->
                        class_7919.method_47407(
                                class_2561.method_43471("better-player-list.settings.footer.tooltip")
                        )
                ).method_57720(class_2561.method_43471("better-player-list.settings.footer"),
                        (w, v) -> settings.setFooter(v));

        var hold = class_5676
                .method_32607(
                        class_2561.method_43471("better-player-list.settings.key.hold"),
                        class_2561.method_43471("better-player-list.settings.key.toggle"),
                        settings.shouldHold()
                )
                .method_32618((v) ->
                        class_7919.method_47407(
                                class_2561.method_43469("better-player-list.settings.key.tooltip",
                                        class_2561.method_43471(client.field_1690.field_1907.method_1428())
                                                .method_27694(s -> s.method_10982(true))
                                )
                        )
                ).method_57720(class_2561.method_43471("better-player-list.settings.key"),
                        (w, v) -> settings.setShouldHold(v));

        var symbols = class_5676
                .method_32606(LatencyDisplayMode::getName, settings.getLatencyDisplayMode())
                .method_32624(LatencyDisplayMode.values())
                .method_32618((v) -> class_7919.method_47407(class_2561.method_43471(v.getPath() + ".tooltip")))
                .method_57720(
                        class_2561.method_43471("better-player-list.settings.latency-symbols"),
                        (w, v) -> settings.setLatencyDisplayMode(v)
                );

        var forceHeads = class_5676.method_32614(settings.forcesHeads())
                .method_32618((v) ->
                        class_7919.method_47407(
                                class_2561.method_43471("better-player-list.settings.force-heads.tooltip")
                        )
                ).method_57720(class_2561.method_43471("better-player-list.settings.force-heads"),
                        (w, v) -> settings.setForceHeads(v));

        if (!settings.shouldRenderHeads()) {
            forceHeads.field_22763 = false;
        }

        var renderHeads = class_5676.method_32614(settings.shouldRenderHeads())
                .method_32618((v) ->
                        class_7919.method_47407(
                                class_2561.method_43471("better-player-list.settings.render-heads.tooltip")
                        )
                ).method_57720(class_2561.method_43471("better-player-list.settings.render-heads"),
                        (w, v) -> {
                            settings.setShouldRenderHeads(v);
                            forceHeads.field_22763 = v;
                        });

        field_51824.method_58227(
                List.of(header, footer, hold, symbols, renderHeads, forceHeads)
        );
    }

    @Override
    public void method_25419() {
        super.method_25419();
        settings.save();
    }
}
