/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.tooldurabilitywarning;

import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.hicham.tooldurabilitywarning.config.ToolDurabilityWarningConfig;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class ToolDurabilityWarningMod
implements ClientModInitializer {
    private static final int CHECK_INTERVAL = 20;
    private final Set<String> warned = new HashSet<String>();
    private int ticks = 0;
    private class_304 configKeyBinding;

    public void onInitializeClient() {
        this.configKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.tooldurabilitywarning.config", class_3675.class_307.field_1668, -1, "category.tooldurabilitywarning.main"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            if (this.configKeyBinding.method_1436()) {
                this.cycleThreshold();
            }
            if (++this.ticks < 20) {
                return;
            }
            this.ticks = 0;
            this.checkDurability(client);
        });
    }

    private void checkDurability(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        this.checkItem(client.field_1724.method_6047(), "mainhand");
        this.checkItem(client.field_1724.method_6079(), "offhand");
        this.checkItem(client.field_1724.method_6118(class_1304.field_6169), "head");
        this.checkItem(client.field_1724.method_6118(class_1304.field_6174), "chest");
        this.checkItem(client.field_1724.method_6118(class_1304.field_6172), "legs");
        this.checkItem(client.field_1724.method_6118(class_1304.field_6166), "feet");
    }

    private double getThresholdForItem(class_1799 stack) {
        ToolDurabilityWarningConfig config = ToolDurabilityWarningConfig.getInstance();
        int unbreakingLevel = 0;
        for (class_6880 entry : stack.method_58657().method_57534()) {
            if (!entry.method_40225(class_1893.field_9119)) continue;
            unbreakingLevel = stack.method_58657().method_57536(entry);
            break;
        }
        return switch (unbreakingLevel) {
            case 1 -> config.threshold * 0.6;
            case 2 -> config.threshold * 0.4;
            case 3 -> config.threshold * 0.2;
            default -> config.threshold;
        };
    }

    private void checkItem(class_1799 stack, String slot) {
        double threshold;
        if (stack.method_7960() || !stack.method_7963()) {
            return;
        }
        if (!this.isTool(stack) && !this.isArmor(stack)) {
            return;
        }
        String key = slot + ":" + String.valueOf(stack.method_7909());
        double durabilityPercent = (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936();
        if (durabilityPercent <= (threshold = this.getThresholdForItem(stack)) && this.warned.add(key)) {
            if (this.isTool(stack)) {
                this.warnPlayer(stack, "tool");
            } else if (this.isArmor(stack)) {
                this.warnPlayer(stack, "armor");
            }
        }
        if (durabilityPercent > threshold + 0.05) {
            this.warned.remove(key);
        }
    }

    private boolean isTool(class_1799 stack) {
        return stack.method_31573(class_3489.field_42614) || stack.method_31573(class_3489.field_42612) || stack.method_31573(class_3489.field_42615) || stack.method_31573(class_3489.field_42613) || stack.method_31573(class_3489.field_42611) || stack.method_31573(class_3489.field_48306);
    }

    private boolean isArmor(class_1799 stack) {
        return stack.method_31573(class_3489.field_48297) || stack.method_31573(class_3489.field_48296) || stack.method_31573(class_3489.field_48295) || stack.method_31573(class_3489.field_48294);
    }

    private void warnPlayer(class_1799 stack, String type) {
        class_5250 message;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        ToolDurabilityWarningConfig config = ToolDurabilityWarningConfig.getInstance();
        double durabilityPercent = (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936();
        if (config.enableSound) {
            if (type.equals("tool")) {
                client.field_1724.method_5783((class_3414)class_3417.field_14622.comp_349(), 1.0f, 0.5f + (float)(1.0 - durabilityPercent / config.threshold) * 0.5f);
            } else {
                client.field_1724.method_5783((class_3414)class_3417.field_15114.comp_349(), 1.0f, 0.7f + (float)(1.0 - durabilityPercent / config.threshold) * 0.3f);
            }
        }
        if (type.equals("tool")) {
            message = class_2561.method_43469((String)"message.tooldurabilitywarning.warning", (Object[])new Object[]{stack.method_7964(), String.format("%.0f%%", durabilityPercent * 100.0)}).method_27692(class_124.field_1061);
        } else {
            String armorType = this.getArmorTypeName(stack);
            message = class_2561.method_43469((String)"message.armordurabilitywarning.warning", (Object[])new Object[]{class_2561.method_43471((String)("message.armordurabilitywarning." + armorType)), String.format("%.0f%%", durabilityPercent * 100.0)}).method_27692(class_124.field_1065);
        }
        client.field_1724.method_7353((class_2561)message, true);
    }

    private String getArmorTypeName(class_1799 stack) {
        if (stack.method_31573(class_3489.field_48296)) {
            return "chestplate";
        }
        if (stack.method_31573(class_3489.field_48297)) {
            return "helmet";
        }
        if (stack.method_31573(class_3489.field_48295)) {
            return "leggings";
        }
        if (stack.method_31573(class_3489.field_48294)) {
            return "boots";
        }
        return "generic";
    }

    private void cycleThreshold() {
        ToolDurabilityWarningConfig config = ToolDurabilityWarningConfig.getInstance();
        if (config.threshold == 0.1) {
            config.threshold = 0.2;
            this.sendConfigMessage("message.tooldurabilitywarning.threshold_20");
        } else if (config.threshold == 0.2) {
            config.threshold = 0.05;
            this.sendConfigMessage("message.tooldurabilitywarning.threshold_5");
        } else {
            config.threshold = 0.1;
            this.sendConfigMessage("message.tooldurabilitywarning.threshold_10");
        }
        config.save();
    }

    private void sendConfigMessage(String translationKey) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.tooldurabilitywarning.prefix").method_10852((class_2561)class_2561.method_43471((String)translationKey)).method_27692(class_124.field_1065), false);
        }
    }
}

