/*
 * Decompiled with CFR 0.152.
 */
package net.hicham.tooldurabilitywarning.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ToolDurabilityWarningConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "tool-durability-warning.json");
    private static ToolDurabilityWarningConfig INSTANCE;
    public double threshold = 0.1;
    public boolean enableSound = true;

    public static ToolDurabilityWarningConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = ToolDurabilityWarningConfig.load();
        }
        return INSTANCE;
    }

    public static ToolDurabilityWarningConfig load() {
        ToolDurabilityWarningConfig toolDurabilityWarningConfig;
        if (!CONFIG_FILE.exists()) {
            ToolDurabilityWarningConfig config = new ToolDurabilityWarningConfig();
            config.save();
            return config;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            toolDurabilityWarningConfig = (ToolDurabilityWarningConfig)GSON.fromJson((Reader)reader, ToolDurabilityWarningConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new ToolDurabilityWarningConfig();
            }
        }
        reader.close();
        return toolDurabilityWarningConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }
}

