/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels.command;

import build.worldlevels.acf.BaseCommand;
import build.worldlevels.acf.CommandHelp;
import build.worldlevels.acf.annotation.CommandAlias;
import build.worldlevels.acf.annotation.CommandPermission;
import build.worldlevels.acf.annotation.Default;
import build.worldlevels.acf.annotation.Description;
import build.worldlevels.acf.annotation.HelpCommand;
import build.worldlevels.acf.annotation.Subcommand;
import com.astrelion.worldlevels.WorldLevels;
import com.astrelion.worldlevels.config.Configuration;
import com.astrelion.worldlevels.config.Save;
import com.astrelion.worldlevels.listener.Experience;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CommandAlias(value="%base")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/astrelion/worldlevels/command/WLBaseCommand;", "Lbuild/worldlevels/acf/BaseCommand;", "plugin", "Lcom/astrelion/worldlevels/WorldLevels;", "<init>", "(Lcom/astrelion/worldlevels/WorldLevels;)V", "getPlugin", "()Lcom/astrelion/worldlevels/WorldLevels;", "doHelp", "", "sender", "Lorg/bukkit/command/CommandSender;", "help", "Lbuild/worldlevels/acf/CommandHelp;", "doReload", "onXPGet", "onXPAdd", "xp", "", "onXPSet", "onUpdate", "onVersion", "onResetAll", "onResetRewards", "player", "Lorg/bukkit/entity/Player;", "WorldLevels"})
public final class WLBaseCommand
extends BaseCommand {
    @NotNull
    private final WorldLevels plugin;

    @NotNull
    public final WorldLevels getPlugin() {
        return this.plugin;
    }

    public WLBaseCommand(@NotNull WorldLevels plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        this.plugin = plugin;
    }

    @Default
    @HelpCommand
    @Description(value="Show help")
    @CommandPermission(value="worldlevels.help")
    public final void doHelp(@NotNull CommandSender sender, @NotNull CommandHelp help) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Intrinsics.checkNotNullParameter(help, "help");
        help.showHelp();
    }

    @Subcommand(value="reload")
    @Description(value="Reload plugin configuration")
    @CommandPermission(value="worldlevels.reload")
    public final void doReload(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        this.plugin.reload();
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnReload(), true));
    }

    @Subcommand(value="xp")
    @Description(value="Get XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.get")
    public final void onXPGet(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Save save = this.plugin.getSave();
        Configuration state = this.plugin.getConfig();
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnXPGet(), true));
    }

    @Subcommand(value="xp add")
    @Description(value="Add XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.add")
    public final void onXPAdd(@NotNull CommandSender sender, double xp) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        this.plugin.getExperience().addExperience(xp);
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="xp set")
    @Description(value="Add XP")
    @CommandPermission(value="worldlevels.xp|worldlevels.xp.set")
    public final void onXPSet(@NotNull CommandSender sender, double xp) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        Experience.setExperience$default(this.plugin.getExperience(), xp, false, 2, null);
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="update")
    @Description(value="Check for plugin updates")
    @CommandPermission(value="worldlevels.update")
    public final void onUpdate(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        boolean update = this.plugin.checkForUpdate();
        if (update) {
            sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnUpdateAvailable(), true));
        } else {
            sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnNoUpdateAvailable(), true));
        }
    }

    @Subcommand(value="version")
    @Description(value="Print the plugin version")
    @CommandPermission(value="worldlevels.version")
    public final void onVersion(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnVersion(), true));
        this.onUpdate(sender);
    }

    @Subcommand(value="reset all")
    @Description(value="Sets XP back to 0 and resets all level-up rewards")
    @CommandPermission(value="worldlevels.reset.all")
    public final void onResetAll(@NotNull CommandSender sender) {
        Intrinsics.checkNotNullParameter(sender, "sender");
        this.onResetRewards(sender, null);
        this.plugin.getExperience().setExperience(0.0, true);
        this.plugin.getConfig().init();
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }

    @Subcommand(value="reset rewards")
    @Description(value="Resets level-up rewards, allowing players to get them again")
    @CommandPermission(value="worldlevels.reset.rewards")
    public final void onResetRewards(@NotNull CommandSender sender, @Nullable Player player) {
        List<Object> list;
        Intrinsics.checkNotNullParameter(sender, "sender");
        Player player2 = player;
        if (player2 == null) {
            Collection collection = this.plugin.getServer().getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers(...)");
            list = CollectionsKt.toList(collection);
        } else {
            list = CollectionsKt.listOf(player2);
        }
        List<Player> players = list;
        for (Player player3 : players) {
            Experience experience = this.plugin.getExperience();
            Intrinsics.checkNotNull(player3);
            experience.removeProcessKey(player3);
        }
        sender.sendMessage(this.plugin.getMessages().parse(this.plugin.getMessages().getData().getOnSuccess(), true));
    }
}

