/*
 * Decompiled with CFR 0.152.
 */
package com.astrelion.worldlevels;

import build.worldlevels.acf.PaperCommandManager;
import com.astrelion.worldlevels.command.WLBaseCommand;
import com.astrelion.worldlevels.config.Configuration;
import com.astrelion.worldlevels.config.Save;
import com.astrelion.worldlevels.listener.Experience;
import com.astrelion.worldlevels.listener.PortalEnter;
import com.astrelion.worldlevels.permission.WLPermissions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.papermc.paper.threadedregions.scheduler.AsyncScheduler;
import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.milkbowl.vault.economy.Economy;
import org.bstats.bukkit.Metrics;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\u0006\u00102\u001a\u000200J\u0006\u00103\u001a\u00020\rJ\b\u00104\u001a\u00020\rH\u0002J\b\u00105\u001a\u00020\rH\u0002J\b\u00106\u001a\u00020\rH\u0002J\u0006\u00107\u001a\u00020\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u0011@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0015@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0019@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\u001d@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010\f\u001a\u0004\u0018\u00010!@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\"\u0010&\u001a\u0004\u0018\u00010%2\b\u0010\f\u001a\u0004\u0018\u00010%@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00068"}, d2={"Lcom/astrelion/worldlevels/WorldLevels;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "modrinthSlug", "", "getModrinthSlug", "()Ljava/lang/String;", "bstatsID", "", "getBstatsID", "()I", "value", "", "updateAvailable", "getUpdateAvailable", "()Z", "Lcom/astrelion/worldlevels/config/Configuration;", "config", "getConfig", "()Lcom/astrelion/worldlevels/config/Configuration;", "Lcom/astrelion/worldlevels/config/Save;", "save", "getSave", "()Lcom/astrelion/worldlevels/config/Save;", "Lorg/bukkit/event/Listener;", "event", "getEvent", "()Lorg/bukkit/event/Listener;", "Lcom/astrelion/worldlevels/listener/Experience;", "experience", "getExperience", "()Lcom/astrelion/worldlevels/listener/Experience;", "Lnet/milkbowl/vault/economy/Economy;", "vaultEconomy", "getVaultEconomy", "()Lnet/milkbowl/vault/economy/Economy;", "Lnet/milkbowl/vault/permission/Permission;", "vaultPermissions", "getVaultPermissions", "()Lnet/milkbowl/vault/permission/Permission;", "metrics", "Lorg/bstats/bukkit/Metrics;", "getMetrics", "()Lorg/bstats/bukkit/Metrics;", "setMetrics", "(Lorg/bstats/bukkit/Metrics;)V", "onEnable", "", "onDisable", "reload", "hasVault", "setupEconomy", "setupPermissions", "isFolia", "checkForUpdate", "WorldLevels"})
public final class WorldLevels
extends JavaPlugin {
    @NotNull
    private final String modrinthSlug;
    private final int bstatsID;
    private boolean updateAvailable;
    private Configuration config;
    private Save save;
    private Listener event;
    private Experience experience;
    @Nullable
    private Economy vaultEconomy;
    @Nullable
    private net.milkbowl.vault.permission.Permission vaultPermissions;
    public Metrics metrics;

    public WorldLevels() {
        this.modrinthSlug = "world-levels";
        this.bstatsID = 15702;
    }

    @NotNull
    public final String getModrinthSlug() {
        return this.modrinthSlug;
    }

    public final int getBstatsID() {
        return this.bstatsID;
    }

    public final boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    @NotNull
    public final Configuration getConfig() {
        Configuration configuration = this.config;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException("config");
        return null;
    }

    @NotNull
    public final Save getSave() {
        Save save = this.save;
        if (save != null) {
            return save;
        }
        Intrinsics.throwUninitializedPropertyAccessException("save");
        return null;
    }

    @NotNull
    public final Listener getEvent() {
        Listener listener = this.event;
        if (listener != null) {
            return listener;
        }
        Intrinsics.throwUninitializedPropertyAccessException("event");
        return null;
    }

    @NotNull
    public final Experience getExperience() {
        Experience experience = this.experience;
        if (experience != null) {
            return experience;
        }
        Intrinsics.throwUninitializedPropertyAccessException("experience");
        return null;
    }

    @Nullable
    public final Economy getVaultEconomy() {
        return this.vaultEconomy;
    }

    @Nullable
    public final net.milkbowl.vault.permission.Permission getVaultPermissions() {
        return this.vaultPermissions;
    }

    @NotNull
    public final Metrics getMetrics() {
        Metrics metrics = this.metrics;
        if (metrics != null) {
            return metrics;
        }
        Intrinsics.throwUninitializedPropertyAccessException("metrics");
        return null;
    }

    public final void setMetrics(@NotNull Metrics metrics) {
        Intrinsics.checkNotNullParameter(metrics, "<set-?>");
        this.metrics = metrics;
    }

    public void onEnable() {
        this.save = new Save(this);
        this.config = new Configuration(this);
        if (!this.getConfig().getEnabled()) {
            this.getLogger().log(Level.SEVERE, "Plugin disabled in config.yml, disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.hasVault()) {
            this.setupEconomy();
            this.setupPermissions();
        } else {
            this.getLogger().log(Level.WARNING, "Vault not found, some functionality disabled");
        }
        this.experience = new Experience(this);
        this.event = new PortalEnter(this);
        for (Permission permission : WLPermissions.INSTANCE.allPermissions()) {
            this.getServer().getPluginManager().addPermission(permission);
        }
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.enableUnstableAPI("help");
        manager.getCommandReplacements().addReplacement("base", "worldlevels");
        manager.registerCommand(new WLBaseCommand(this));
        this.setMetrics(new Metrics((Plugin)this, this.bstatsID));
        AsyncScheduler asyncScheduler = this.getServer().getAsyncScheduler();
        Intrinsics.checkNotNullExpressionValue(asyncScheduler, "getAsyncScheduler(...)");
        AsyncScheduler scheduler = asyncScheduler;
        scheduler.runAtFixedRate((Plugin)this, arg_0 -> WorldLevels.onEnable$lambda$0(this, arg_0), 0L, 1L, TimeUnit.DAYS);
        this.getLogger().log(Level.INFO, "Enabled");
    }

    public void onDisable() {
        this.getSave().save();
        this.getLogger().log(Level.INFO, "Disabled");
    }

    public final void reload() {
        this.getSave().reload();
        this.getConfig().reload();
        this.getExperience().reload();
    }

    public final boolean hasVault() {
        return this.getServer().getPluginManager().getPlugin("Vault") != null;
    }

    private final boolean setupEconomy() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        this.vaultEconomy = (Economy)rsp.getProvider();
        return true;
    }

    private final boolean setupPermissions() {
        RegisteredServiceProvider registeredServiceProvider = this.getServer().getServicesManager().getRegistration(net.milkbowl.vault.permission.Permission.class);
        if (registeredServiceProvider == null) {
            return false;
        }
        RegisteredServiceProvider rsp = registeredServiceProvider;
        this.vaultPermissions = (net.milkbowl.vault.permission.Permission)rsp.getProvider();
        return true;
    }

    private final boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public final boolean checkForUpdate() {
        String loader = this.isFolia() ? "folia" : "paper";
        String string = this.getServer().getMinecraftVersion();
        Intrinsics.checkNotNullExpressionValue(string, "getMinecraftVersion(...)");
        String mcVersion = string;
        String loaderParams = URLEncoder.encode("[\"" + loader + "\"]", StandardCharsets.UTF_8);
        String versionParams = URLEncoder.encode("[\"" + mcVersion + "\"]", StandardCharsets.UTF_8);
        URL modrinthURL = URI.create("https://api.modrinth.com/v2/project/" + this.modrinthSlug + "/version?loaders=" + loaderParams + "&game_versions=" + versionParams).toURL();
        String response = "";
        try {
            Intrinsics.checkNotNull(modrinthURL);
            URL uRL = modrinthURL;
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes(uRL);
            response = new String(byArray, charset);
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to check for updates");
            return false;
        }
        Gson gson = new GsonBuilder().create();
        JsonElement json = gson.toJsonTree(gson.fromJson(response, Object[].class));
        JsonArray rootArray = json.getAsJsonArray();
        if (rootArray.size() == 0) {
            return false;
        }
        String recentVersion = rootArray.get(0).getAsJsonObject().get("version_number").getAsString();
        Intrinsics.checkNotNull(recentVersion);
        int recentVersionInt = Integer.parseInt(StringsKt.replace$default(recentVersion, ".", "", false, 4, null));
        String string2 = this.getPluginMeta().getVersion();
        Intrinsics.checkNotNullExpressionValue(string2, "getVersion(...)");
        int thisVersionInt = Integer.parseInt(StringsKt.replace$default(string2, ".", "", false, 4, null));
        boolean bl = this.updateAvailable = recentVersionInt > thisVersionInt;
        if (this.updateAvailable) {
            this.getLogger().log(Level.INFO, "New update available! https://modrinth.com/project/" + this.modrinthSlug);
            return true;
        }
        return false;
    }

    private static final void onEnable$lambda$0(WorldLevels this$0, ScheduledTask it) {
        this$0.checkForUpdate();
    }
}

